const _dom = `
<style>
	.zappar-world-tracker-ui {
		position: fixed;
		top: 0;
		left: 0;
		pointer-events: none;
		overflow: hidden;
		display: flex;
		flex-direction: column;
		align-items: center;
    	justify-content: center;
	}

	.zappar-world-tracker-ui-container {
		position: absolute;
		width: 208px;
		height: 208px;
		background: rgba(48, 48, 48, 0.87);
		border-radius: 16px;
		font-family: sans-serif;
		font-style: normal;
		font-weight: 500;
		font-size: 14px;
		line-height: 17px;
		text-align: center;
		color: white;
		display: flex;
		flex-direction: column;
		padding: 20px 30px;
		padding-bottom: 30px;
		box-sizing: border-box;
	}

	#zappar-world-tracker-ui-text {
		height: 34px;
	}

	.zappar-world-tracker-ui-animation {
		flex-grow: 1;
		display: flex;
		flex-direction: column;
		align-items: center;
		justify-content: center;
	}
	.zappar-world-tracker-ui-animation > svg {
		width: 128px;
	}
</style>

<div class="zappar-world-tracker-ui-container">
	<div class="zappar-world-tracker-ui-animation">
		<svg id="eefv1bMyhqS1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 128 88" shape-rendering="geometricPrecision" text-rendering="geometricPrecision">
		<style><![CDATA[
		#eefv1bMyhqS25_to {animation: eefv1bMyhqS25_to__to 3000ms linear infinite normal forwards}@keyframes eefv1bMyhqS25_to__to { 0% {offset-distance: 0%;animation-timing-function: cubic-bezier(0.42,0,0.58,1)} 26.666667% {offset-distance: 50%} 56.666667% {offset-distance: 50%;animation-timing-function: cubic-bezier(0.42,0,0.58,1)} 83.333333% {offset-distance: 100%} 100% {offset-distance: 100%}} #eefv1bMyhqS25_ts {animation: eefv1bMyhqS25_ts__ts 3000ms linear infinite normal forwards}@keyframes eefv1bMyhqS25_ts__ts { 0% {transform: scale(0.709677,0.709677);animation-timing-function: cubic-bezier(0.42,0,0.58,1)} 26.666667% {transform: scale(0.4,0.4)} 56.666667% {transform: scale(0.4,0.4);animation-timing-function: cubic-bezier(0.42,0,0.58,1)} 83.333333% {transform: scale(0.709677,0.709677)} 100% {transform: scale(0.709677,0.709677)}}
		]]></style>
		<defs><linearGradient id="eefv1bMyhqS24-stroke" x1="50" y1="32" x2="50" y2="0" spreadMethod="pad" gradientUnits="userSpaceOnUse" gradientTransform="translate(0 0)"><stop id="eefv1bMyhqS24-stroke-0" offset="0%" stop-color="#fff"/><stop id="eefv1bMyhqS24-stroke-1" offset="100%" stop-color="#a3a3a3"/></linearGradient></defs><ellipse rx="2" ry="1.00787" transform="translate(19 54.4252)" fill="#fff" fill-opacity="0.15"/><ellipse rx="2" ry="1.00787" transform="translate(37 54.4252)" fill="#fff"/><ellipse rx="2" ry="1.00787" transform="translate(55 54.4252)" fill="#fff"/><ellipse rx="2" ry="1.00787" transform="translate(73 54.4252)" fill="#fff"/><ellipse rx="2" ry="1.00787" transform="translate(91 54.4252)" fill="#fff"/><ellipse rx="2" ry="1.00787" transform="translate(109 54.4252)" fill="#fff" fill-opacity="0.5"/><ellipse rx="2" ry="1.00787" transform="translate(21 45.3543)" fill="#fff" fill-opacity="0.15"/><ellipse rx="2" ry="1.00787" transform="translate(39 45.3543)" fill="#fff"/><ellipse rx="2" ry="1.00787" transform="translate(56 45.3543)" fill="#fff"/><ellipse rx="2" ry="1.00787" transform="translate(72 45.3543)" fill="#fff"/><ellipse rx="2" ry="1.00787" transform="translate(89 45.3543)" fill="#fff"/><ellipse rx="2" ry="1.00787" transform="translate(107 45.3543)" fill="#fff" fill-opacity="0.15"/><ellipse rx="2" ry="1.00788" transform="translate(23 36.2835)" fill="#fff" fill-opacity="0.15"/><ellipse rx="2" ry="1.00788" transform="translate(41 36.2835)" fill="#fff" fill-opacity="0.4"/><ellipse rx="2" ry="1.00788" transform="translate(57 36.2835)" fill="#fff" fill-opacity="0.6"/><ellipse rx="2" ry="1.00788" transform="translate(71 36.2835)" fill="#fff" fill-opacity="0.6"/><ellipse rx="2" ry="1.00788" transform="translate(87 36.2835)" fill="#fff" fill-opacity="0.4"/><ellipse rx="2" ry="1.00788" transform="translate(105 36.2835)" fill="#fff" fill-opacity="0.15"/><ellipse rx="2" ry="1.00787" transform="translate(43 27.2126)" fill="#fff" fill-opacity="0.15"/><ellipse rx="2" ry="1.00787" transform="translate(58 27.2126)" fill="#fff" fill-opacity="0.1"/><ellipse rx="2" ry="1.00787" transform="translate(69 27.2126)" fill="#fff" fill-opacity="0.1"/><ellipse rx="2" ry="1.00787" transform="translate(85 27.2126)" fill="#fff" fill-opacity="0.07"/><path d="M22.2462,1h83.5078c3.212,0,6.012,2.18608,6.791,5.30225l12,48.00005C125.649,58.7203,122.308,63,117.754,63h-107.5078c-4.55399,0-7.89549-4.2797-6.79099-8.6978L15.4552,6.30225C16.2343,3.18608,19.0341,1,22.2462,1Z" fill="none" stroke="url(#eefv1bMyhqS24-stroke)" stroke-width="2"/><g id="eefv1bMyhqS25_to" style="offset-path:path('M63.999993,60C63.999993,60,64,37.449592,64,37.449592L64,37.449592L63.999993,60');offset-rotate:0deg"><g id="eefv1bMyhqS25_ts" transform="scale(0.709677,0.709677)"><rect width="31" height="55" rx="3.5" ry="3.5" transform="translate(-15.5,-27.5)" fill="#5b5b5b" stroke="#fff"/></g></g></svg>
	</div>
	<div id="zappar-world-tracker-ui-text">Move forward and back to find a surface</div>
</div>
`;
export class WorldTrackerUI {
    constructor(_canvas) {
        this._canvas = _canvas;
        this.dom = document.createElement('div');
        this._lastRect = new DOMRect(0, 0, 0, 0);
        this.dom.innerHTML = _dom;
        this.dom.className = 'zappar-world-tracker-ui';
    }
    setText(t) {
        const text = this.dom.querySelector('#zappar-world-tracker-ui-text');
        text.innerText = t;
    }
    update() {
        const rect = this._canvas.getBoundingClientRect();
        if (this._lastRect && this._lastRect.top === rect.top && this._lastRect.left === rect.left && this._lastRect.width === rect.width && this._lastRect.height === rect.height)
            return;
        this.dom.style.top = rect.top.toString() + 'px';
        this.dom.style.left = rect.left.toString() + 'px';
        this.dom.style.width = rect.width.toString() + 'px';
        this.dom.style.height = rect.height.toString() + 'px';
    }
    show() {
        if (this.dom.parentElement)
            return;
        document.body.appendChild(this.dom);
    }
    hide() {
        this.dom.remove();
    }
}
