export interface PlaneData {
    width: number;
    height: number;
    data: Uint8Array;
}
export interface UvPlaneData {
    width: number;
    height: number;
    data: Uint8Array;
    dataVPlane?: Uint8Array;
}
export declare enum UvLayout {
    INTERLEAVED_UV = 0,
    INTERLEAVED_VU = 1,
    PLANAR_UV = 2
}
export declare class YUVConversionGL {
    private _gl;
    private _yTexture;
    private _uvTexture;
    private _uvTextureSinglePlane;
    private _vTexture;
    private _framebufferId;
    private _vao;
    private _vertexBuffer;
    private _conversionShaders;
    private _isWebGL2;
    private _useVao;
    private _oneComponentInternalFormat;
    private _oneComponentFormat;
    private _twoComponentInternalFormat;
    private _twoComponentFormat;
    private _vaoExtension;
    private _instancedArraysExtension;
    constructor(_gl: WebGL2RenderingContext | WebGLRenderingContext);
    resetGLContext(): void;
    destroy(): void;
    yuvToTexture(y: PlaneData, uv: UvPlaneData, uvLayout: UvLayout, destination: WebGLTexture): void;
    private _getVertexAttribState;
    private _prepareContext;
    private _prepareConversionShader;
    private _prepareTextures;
    private _createSizedTexture;
}
