export class UserTimingTracer {
    constructor(useFixedName = false) {
        this.useFixedName = useFixedName;
        this.markCount = 0;
        this.traceStack = [];
    }
    clear() {
        this.traceStack = [];
    }
    start(name) {
        const markName = name + '_' + this.markCount.toFixed(0);
        this.markCount++;
        const startName = markName + '_s';
        const endName = markName + '_e';
        this.traceStack.push([name, startName, endName]);
        performance.mark(startName);
    }
    end() {
        let last = this.traceStack.pop();
        if (!last)
            return;
        performance.mark(last[2]);
        if (this.useFixedName) {
            performance.measure("ZTracing", { start: last[1], end: last[2], detail: { name: last[0] } });
        }
        else {
            performance.measure(last[0], last[1], last[2]);
        }
    }
}
