export class JSONTracer {
    constructor() {
        this.stackDepth = 0;
        this.events = [];
        this.events = [...JSONTracer.namingEvents];
    }
    clear() {
        this.stackDepth = 0;
        this.events = [...JSONTracer.namingEvents];
    }
    toJSON() {
        return JSON.stringify(this.events);
    }
    postJSON(url) {
        fetch(url, { method: 'POST', body: this.toJSON() });
    }
    start(name) {
        this.stackDepth++;
        let beginEvent = Object.assign({ "name": name }, JSONTracer.beginTemplate);
        this.events.push(beginEvent);
        beginEvent.ts = Math.round(performance.now() * 1000);
    }
    end() {
        let endTimestamp = Math.round(performance.now() * 1000);
        if (this.stackDepth <= 0)
            return;
        this.stackDepth--;
        let endEvent = Object.assign({ "ts": endTimestamp }, JSONTracer.endTemplate);
        this.events.push(endEvent);
    }
}
JSONTracer.beginTemplate = { "ts": 0, "cat": "zcv", "ph": "B", "pid": 100, "tid": 100 };
JSONTracer.endTemplate = { "ph": "E", "pid": 100, "tid": 100 };
JSONTracer.namingEvents = [
    { "name": "process_name", "ph": "M", "pid": 100, "args": { "name": "Content Process" } },
    { "name": "thread_name", "ph": "M", "pid": 100, "tid": 100, "args": { "name": "UI Thread" } }
];
