/// <reference types="dom-webcodecs" />
import { CameraFrameData } from "./camera-frame-data";
import { camera_profile_t, zappar_camera_source_t, zappar_pipeline_t } from "./gen/zappar-native";
export interface CameraFrameC2S {
    t: "cameraFrameC2S";
    d: ArrayBuffer;
    p: zappar_pipeline_t;
    userFacing: boolean;
    c2d: Float32Array;
    cm: Float32Array;
    token: number;
    width: number;
    height: number;
    captureTime: number;
}
export interface CameraFrameReturnS2C {
    t: "cameraFrameRecycleS2C";
    token: number;
    d: ArrayBuffer;
    p: zappar_pipeline_t;
    att?: Float32Array;
}
export interface VideoFrameS2C {
    t: "videoFrameS2C";
    token: number;
    d: VideoFrame;
    p: zappar_pipeline_t;
    source: zappar_camera_source_t;
    userFacing: boolean;
    uvTransform: Float32Array;
    w: number;
    h: number;
    cameraModel: Float32Array;
    cameraToDevice: Float32Array;
}
export interface StreamC2S {
    t: "streamC2S";
    p: zappar_pipeline_t;
    s: ReadableStream<VideoFrame>;
    userFacing: boolean;
    source: zappar_camera_source_t;
}
export interface CameraProfileC2S {
    t: "cameraProfileC2S";
    p: zappar_pipeline_t;
    source: zappar_camera_source_t;
    profile: camera_profile_t;
}
export interface CameraToScreenRotationC2S {
    t: "cameraToScreenC2S";
    p: zappar_pipeline_t;
    r: number;
}
export interface ImageBitmapC2S {
    t: "imageBitmapC2S";
    p: zappar_pipeline_t;
    i: ImageBitmap;
    r: number;
    userFacing: boolean;
    tokenId: number;
    cameraModel: Float32Array;
    cameraToDevice: Float32Array;
    cp: camera_profile_t;
    requestData?: boolean;
}
export interface ImageBitmapS2C {
    t: "imageBitmapS2C";
    p: zappar_pipeline_t;
    dataWidth: number;
    dataHeight: number;
    data?: ArrayBuffer;
    uvTransform: Float32Array;
    userFacing: boolean;
    frame: ImageBitmap;
    tokenId: number;
}
export interface StreamEndedS2C {
    t: "streamEndedS2C";
    p: zappar_pipeline_t;
    source: zappar_camera_source_t;
}
export interface SensorDataC2S {
    t: "sensorDataC2S";
    sensor: "accel" | "accel_wo_gravity_int" | "accel_w_gravity_int" | "rotation_rate_int" | "attitude_int" | "rotation_rate" | "attitude" | "relative_orientation";
    p: zappar_pipeline_t;
    x: number;
    y: number;
    z: number;
    w?: number;
    timestamp: number;
    interval: number;
}
export interface AttitudeMatrixC2S {
    t: "attitudeMatrixC2S";
    p: zappar_pipeline_t;
    m: Float32Array;
}
export interface CameraDataRawEnabledC2S {
    t: "rawenabled";
    v: boolean;
}
export interface CameraDataRawRequestC2S {
    t: "rawrequest";
    p: zappar_pipeline_t;
    token: number;
}
export interface CameraDataRawS2C {
    t: "raw";
    token: number;
    p: zappar_pipeline_t;
    data: CameraFrameData | null;
}
