import { barcode_format_t } from "./zappar-native";
export { barcode_format_t } from "./zappar-native";
import { world_scale_mode_t } from "./zappar-native";
export { world_scale_mode_t } from "./zappar-native";
import { face_landmark_name_t } from "./zappar-native";
export { face_landmark_name_t } from "./zappar-native";
export { frame_pixel_format_t } from "./zappar-native";
import { instant_world_tracker_transform_orientation_t } from "./zappar-native";
export { instant_world_tracker_transform_orientation_t } from "./zappar-native";
import { transform_orientation_t } from "./zappar-native";
export { transform_orientation_t } from "./zappar-native";
import { plane_orientation_t } from "./zappar-native";
export { plane_orientation_t } from "./zappar-native";
import { log_level_t } from "./zappar-native";
export { log_level_t } from "./zappar-native";
import { image_target_type_t } from "./zappar-native";
export { image_target_type_t } from "./zappar-native";
export { world_tracker_quality_t } from "./zappar-native";
import { anchor_status_t } from "./zappar-native";
export { anchor_status_t } from "./zappar-native";
import { camera_profile_t } from "./zappar-native";
export { camera_profile_t } from "./zappar-native";
export declare type zappar_pipeline_t = number & {
    _: 'zappar_pipeline_t';
};
export declare type zappar_camera_source_t = number & {
    _: 'zappar_camera_source_t';
};
export declare type zappar_sequence_source_t = number & {
    _: 'zappar_sequence_source_t';
};
export declare type zappar_image_tracker_t = number & {
    _: 'zappar_image_tracker_t';
};
export declare type zappar_face_tracker_t = number & {
    _: 'zappar_face_tracker_t';
};
export declare type zappar_face_mesh_t = number & {
    _: 'zappar_face_mesh_t';
};
export declare type zappar_face_landmark_t = number & {
    _: 'zappar_face_landmark_t';
};
export declare type zappar_barcode_finder_t = number & {
    _: 'zappar_barcode_finder_t';
};
export declare type zappar_instant_world_tracker_t = number & {
    _: 'zappar_instant_world_tracker_t';
};
export declare type zappar_zapcode_tracker_t = number & {
    _: 'zappar_zapcode_tracker_t';
};
export declare type zappar_world_tracker_t = number & {
    _: 'zappar_world_tracker_t';
};
export declare type zappar_custom_anchor_t = number & {
    _: 'zappar_custom_anchor_t';
};
export declare type zappar_d3_tracker_t = number & {
    _: 'zappar_d3_tracker_t';
};
export interface zappar {
    loaded(): boolean;
    camera_default_device_id(userFacing: boolean): string;
    camera_count(): number;
    camera_id(indx: number): string;
    camera_name(indx: number): string;
    camera_user_facing(indx: number): boolean;
    projection_matrix_from_camera_model_and_size(model: Float32Array, cameraDataWidth: number, cameraDataHeight: number, renderWidth: number, renderHeight: number): Float32Array;
    projection_matrix_from_camera_model_and_size_ext(model: Float32Array, cameraDataWidth: number, cameraDataHeight: number, renderWidth: number, renderHeight: number, zNear: number, zFar: number): Float32Array;
    pose_from_raw(raw_pose: Float32Array, mirror: boolean): Float32Array;
    log_level(): log_level_t;
    log_level_set(level: log_level_t): void;
    permission_request_ui(): void;
    permission_denied_ui(): void;
    permission_request_all(): void;
    permission_request_camera(): void;
    permission_request_motion(): void;
    permission_granted_all(): boolean;
    permission_granted_camera(): boolean;
    permission_granted_motion(): boolean;
    permission_denied_any(): boolean;
    permission_denied_camera(): boolean;
    permission_denied_motion(): boolean;
    analytics_project_id_set(id: string, uid: string): void;
    pipeline_create(): zappar_pipeline_t;
    pipeline_destroy(o: zappar_pipeline_t): void;
    pipeline_camera_frame_upload_gl(o: zappar_pipeline_t): void;
    pipeline_camera_frame_texture_gl(o: zappar_pipeline_t): WebGLTexture | undefined;
    pipeline_camera_frame_texture_matrix(o: zappar_pipeline_t, renderWidth: number, renderHeight: number, mirror: boolean): Float32Array;
    pipeline_process_gl(o: zappar_pipeline_t): void;
    pipeline_frame_update(o: zappar_pipeline_t): void;
    pipeline_frame_number(o: zappar_pipeline_t): number;
    pipeline_camera_model(o: zappar_pipeline_t): Float32Array;
    pipeline_camera_data_width(o: zappar_pipeline_t): number;
    pipeline_camera_data_height(o: zappar_pipeline_t): number;
    pipeline_camera_frame_sharpness_enabled(o: zappar_pipeline_t): boolean;
    pipeline_camera_frame_sharpness_enabled_set(o: zappar_pipeline_t, val: boolean): void;
    pipeline_camera_frame_sharpness(o: zappar_pipeline_t): number;
    pipeline_camera_pose_default(o: zappar_pipeline_t): Float32Array;
    pipeline_camera_pose_with_attitude(o: zappar_pipeline_t, mirror: boolean): Float32Array;
    pipeline_camera_pose_with_origin(o: zappar_pipeline_t, pose: Float32Array): Float32Array;
    pipeline_camera_frame_user_data(o: zappar_pipeline_t): number;
    pipeline_camera_frame_submit(o: zappar_pipeline_t, data: ArrayBuffer, width: number, height: number, user_data: number, camera_to_device_transform: Float32Array, camera_model: Float32Array, user_facing: boolean, timestampMicroseconds: number): void;
    pipeline_camera_frame_camera_attitude(o: zappar_pipeline_t): Float32Array;
    pipeline_camera_frame_device_attitude(o: zappar_pipeline_t): Float32Array;
    pipeline_camera_frame_user_facing(o: zappar_pipeline_t): boolean;
    pipeline_motion_accelerometer_submit(o: zappar_pipeline_t, time: number, x: number, y: number, z: number): void;
    pipeline_motion_accelerometer_with_gravity_submit_int(o: zappar_pipeline_t, time: number, interval: number, x: number, y: number, z: number): void;
    pipeline_motion_accelerometer_without_gravity_submit_int(o: zappar_pipeline_t, time: number, interval: number, x: number, y: number, z: number): void;
    pipeline_motion_rotation_rate_submit(o: zappar_pipeline_t, time: number, x: number, y: number, z: number): void;
    pipeline_motion_rotation_rate_submit_int(o: zappar_pipeline_t, time: number, interval: number, x: number, y: number, z: number): void;
    pipeline_motion_attitude_submit(o: zappar_pipeline_t, time: number, x: number, y: number, z: number): void;
    pipeline_motion_attitude_submit_int(o: zappar_pipeline_t, time: number, interval: number, x: number, y: number, z: number): void;
    pipeline_motion_relative_orientation_submit_int(o: zappar_pipeline_t, time: number, interval: number, x: number, y: number, z: number, w: number): void;
    pipeline_motion_attitude_matrix_submit(o: zappar_pipeline_t, mat: Float32Array): void;
    pipeline_sequence_record_start(o: zappar_pipeline_t, expected_frames: number): void;
    pipeline_sequence_record_stop(o: zappar_pipeline_t): void;
    pipeline_sequence_record_device_attitude_matrices_set(o: zappar_pipeline_t, val: boolean): void;
    pipeline_sequence_record_data(o: zappar_pipeline_t): Uint8Array;
    pipeline_sequence_record_data_size(o: zappar_pipeline_t): number;
    pipeline_sequence_record_clear(o: zappar_pipeline_t): void;
    camera_source_create(pipeline: zappar_pipeline_t, device_id: string): zappar_camera_source_t;
    camera_source_destroy(o: zappar_camera_source_t): void;
    camera_source_start(o: zappar_camera_source_t): void;
    camera_source_pause(o: zappar_camera_source_t): void;
    camera_source_profile_set(o: zappar_camera_source_t, profile: camera_profile_t): void;
    sequence_source_create(pipeline: zappar_pipeline_t): zappar_sequence_source_t;
    sequence_source_destroy(o: zappar_sequence_source_t): void;
    sequence_source_start(o: zappar_sequence_source_t): void;
    sequence_source_pause(o: zappar_sequence_source_t): void;
    sequence_source_load_from_memory(o: zappar_sequence_source_t, data: ArrayBuffer): void;
    sequence_source_max_playback_fps_set(o: zappar_sequence_source_t, fps: number): void;
    image_tracker_create(pipeline: zappar_pipeline_t): zappar_image_tracker_t;
    image_tracker_destroy(o: zappar_image_tracker_t): void;
    image_tracker_target_load_from_memory(o: zappar_image_tracker_t, data: ArrayBuffer): void;
    image_tracker_target_loaded_version(o: zappar_image_tracker_t): number;
    image_tracker_target_count(o: zappar_image_tracker_t): number;
    image_tracker_target_type(o: zappar_image_tracker_t, indx: number): image_target_type_t;
    image_tracker_target_radius_top(o: zappar_image_tracker_t, indx: number): number;
    image_tracker_target_radius_bottom(o: zappar_image_tracker_t, indx: number): number;
    image_tracker_target_side_length(o: zappar_image_tracker_t, indx: number): number;
    image_tracker_target_physical_scale_factor(o: zappar_image_tracker_t, indx: number): number;
    image_tracker_target_preview_compressed(o: zappar_image_tracker_t, indx: number): Uint8Array;
    image_tracker_target_preview_compressed_size(o: zappar_image_tracker_t, indx: number): number;
    image_tracker_target_preview_compressed_mimetype(o: zappar_image_tracker_t, indx: number): string;
    image_tracker_target_preview_mesh_indices(o: zappar_image_tracker_t, indx: number): Uint16Array;
    image_tracker_target_preview_mesh_indices_size(o: zappar_image_tracker_t, indx: number): number;
    image_tracker_target_preview_mesh_vertices(o: zappar_image_tracker_t, indx: number): Float32Array;
    image_tracker_target_preview_mesh_vertices_size(o: zappar_image_tracker_t, indx: number): number;
    image_tracker_target_preview_mesh_normals(o: zappar_image_tracker_t, indx: number): Float32Array;
    image_tracker_target_preview_mesh_normals_size(o: zappar_image_tracker_t, indx: number): number;
    image_tracker_target_preview_mesh_uvs(o: zappar_image_tracker_t, indx: number): Float32Array;
    image_tracker_target_preview_mesh_uvs_size(o: zappar_image_tracker_t, indx: number): number;
    image_tracker_enabled(o: zappar_image_tracker_t): boolean;
    image_tracker_enabled_set(o: zappar_image_tracker_t, enabled: boolean): void;
    image_tracker_anchor_count(o: zappar_image_tracker_t): number;
    image_tracker_anchor_id(o: zappar_image_tracker_t, indx: number): string;
    image_tracker_anchor_pose_raw(o: zappar_image_tracker_t, indx: number): Float32Array;
    image_tracker_anchor_pose_camera_relative(o: zappar_image_tracker_t, indx: number, mirror: boolean): Float32Array;
    image_tracker_anchor_pose(o: zappar_image_tracker_t, indx: number, camera_pose: Float32Array, mirror: boolean): Float32Array;
    face_tracker_create(pipeline: zappar_pipeline_t): zappar_face_tracker_t;
    face_tracker_destroy(o: zappar_face_tracker_t): void;
    face_tracker_model_load_from_memory(o: zappar_face_tracker_t, data: ArrayBuffer): void;
    face_tracker_model_loaded_version(o: zappar_face_tracker_t): number;
    face_tracker_enabled_set(o: zappar_face_tracker_t, enabled: boolean): void;
    face_tracker_enabled(o: zappar_face_tracker_t): boolean;
    face_tracker_max_faces_set(o: zappar_face_tracker_t, num: number): void;
    face_tracker_max_faces(o: zappar_face_tracker_t): number;
    face_tracker_anchor_count(o: zappar_face_tracker_t): number;
    face_tracker_anchor_id(o: zappar_face_tracker_t, indx: number): string;
    face_tracker_anchor_pose_raw(o: zappar_face_tracker_t, indx: number): Float32Array;
    face_tracker_anchor_pose_camera_relative(o: zappar_face_tracker_t, indx: number, mirror: boolean): Float32Array;
    face_tracker_anchor_pose(o: zappar_face_tracker_t, indx: number, camera_pose: Float32Array, mirror: boolean): Float32Array;
    face_tracker_anchor_identity_coefficients(o: zappar_face_tracker_t, indx: number): Float32Array;
    face_tracker_anchor_expression_coefficients(o: zappar_face_tracker_t, indx: number): Float32Array;
    face_mesh_create(): zappar_face_mesh_t;
    face_mesh_destroy(o: zappar_face_mesh_t): void;
    face_mesh_load_from_memory(o: zappar_face_mesh_t, data: ArrayBuffer, fill_mouth: boolean, fill_eye_l: boolean, fill_eye_r: boolean, fill_neck: boolean): void;
    face_mesh_loaded_version(o: zappar_face_mesh_t): number;
    face_mesh_update(o: zappar_face_mesh_t, identity: Float32Array, expression: Float32Array, mirrored: boolean): void;
    face_mesh_indices_size(o: zappar_face_mesh_t): number;
    face_mesh_indices(o: zappar_face_mesh_t): Uint16Array;
    face_mesh_vertices_size(o: zappar_face_mesh_t): number;
    face_mesh_vertices(o: zappar_face_mesh_t): Float32Array;
    face_mesh_normals_size(o: zappar_face_mesh_t): number;
    face_mesh_normals(o: zappar_face_mesh_t): Float32Array;
    face_mesh_uvs_size(o: zappar_face_mesh_t): number;
    face_mesh_uvs(o: zappar_face_mesh_t): Float32Array;
    face_landmark_create(landmark: face_landmark_name_t): zappar_face_landmark_t;
    face_landmark_destroy(o: zappar_face_landmark_t): void;
    face_landmark_update(o: zappar_face_landmark_t, identity: Float32Array, expression: Float32Array, mirrored: boolean): void;
    face_landmark_anchor_pose(o: zappar_face_landmark_t): Float32Array;
    barcode_finder_create(pipeline: zappar_pipeline_t): zappar_barcode_finder_t;
    barcode_finder_destroy(o: zappar_barcode_finder_t): void;
    barcode_finder_enabled_set(o: zappar_barcode_finder_t, enabled: boolean): void;
    barcode_finder_enabled(o: zappar_barcode_finder_t): boolean;
    barcode_finder_found_number(o: zappar_barcode_finder_t): number;
    barcode_finder_found_text(o: zappar_barcode_finder_t, indx: number): string;
    barcode_finder_found_format(o: zappar_barcode_finder_t, indx: number): barcode_format_t;
    barcode_finder_formats(o: zappar_barcode_finder_t): barcode_format_t;
    barcode_finder_formats_set(o: zappar_barcode_finder_t, f: barcode_format_t): void;
    instant_world_tracker_create(pipeline: zappar_pipeline_t): zappar_instant_world_tracker_t;
    instant_world_tracker_destroy(o: zappar_instant_world_tracker_t): void;
    instant_world_tracker_enabled_set(o: zappar_instant_world_tracker_t, enabled: boolean): void;
    instant_world_tracker_enabled(o: zappar_instant_world_tracker_t): boolean;
    instant_world_tracker_anchor_pose_raw(o: zappar_instant_world_tracker_t): Float32Array;
    instant_world_tracker_anchor_pose_camera_relative(o: zappar_instant_world_tracker_t, mirror: boolean): Float32Array;
    instant_world_tracker_anchor_pose(o: zappar_instant_world_tracker_t, camera_pose: Float32Array, mirror: boolean): Float32Array;
    instant_world_tracker_anchor_pose_set_from_camera_offset_raw(o: zappar_instant_world_tracker_t, x: number, y: number, z: number, orientation: instant_world_tracker_transform_orientation_t): void;
    instant_world_tracker_anchor_pose_set_from_camera_offset(o: zappar_instant_world_tracker_t, x: number, y: number, z: number, orientation: instant_world_tracker_transform_orientation_t): void;
    zapcode_tracker_create(pipeline: zappar_pipeline_t): zappar_zapcode_tracker_t;
    zapcode_tracker_destroy(o: zappar_zapcode_tracker_t): void;
    zapcode_tracker_target_load_from_memory(o: zappar_zapcode_tracker_t, data: ArrayBuffer): void;
    zapcode_tracker_target_loaded_version(o: zappar_zapcode_tracker_t): number;
    zapcode_tracker_enabled(o: zappar_zapcode_tracker_t): boolean;
    zapcode_tracker_enabled_set(o: zappar_zapcode_tracker_t, enabled: boolean): void;
    zapcode_tracker_anchor_count(o: zappar_zapcode_tracker_t): number;
    zapcode_tracker_anchor_id(o: zappar_zapcode_tracker_t, indx: number): string;
    zapcode_tracker_anchor_pose_raw(o: zappar_zapcode_tracker_t, indx: number): Float32Array;
    zapcode_tracker_anchor_pose_camera_relative(o: zappar_zapcode_tracker_t, indx: number, mirror: boolean): Float32Array;
    zapcode_tracker_anchor_pose(o: zappar_zapcode_tracker_t, indx: number, camera_pose: Float32Array, mirror: boolean): Float32Array;
    world_tracker_create(pipeline: zappar_pipeline_t): zappar_world_tracker_t;
    world_tracker_destroy(o: zappar_world_tracker_t): void;
    world_tracker_enabled(o: zappar_world_tracker_t): boolean;
    world_tracker_enabled_set(o: zappar_world_tracker_t, enabled: boolean): void;
    world_tracker_scale_mode(o: zappar_world_tracker_t): world_scale_mode_t;
    world_tracker_scale_mode_set(o: zappar_world_tracker_t, scale_mode: world_scale_mode_t): void;
    world_tracker_session_number(o: zappar_world_tracker_t): number;
    world_tracker_quality(o: zappar_world_tracker_t): number;
    world_tracker_horizontal_plane_detection_enabled(o: zappar_world_tracker_t): boolean;
    world_tracker_horizontal_plane_detection_enabled_set(o: zappar_world_tracker_t, horizontal_plane_detection_enabled: boolean): void;
    world_tracker_vertical_plane_detection_enabled(o: zappar_world_tracker_t): boolean;
    world_tracker_vertical_plane_detection_enabled_set(o: zappar_world_tracker_t, vertical_plane_detection_enabled: boolean): void;
    world_tracker_vertical_plane_detection_supported(o: zappar_world_tracker_t): boolean;
    world_tracker_plane_anchor_count(o: zappar_world_tracker_t): number;
    world_tracker_plane_anchor_id(o: zappar_world_tracker_t, indx: number): string;
    world_tracker_plane_anchor_pose_raw(o: zappar_world_tracker_t, indx: number): Float32Array;
    world_tracker_plane_anchor_status(o: zappar_world_tracker_t, indx: number): anchor_status_t;
    world_tracker_plane_anchor_pose_camera_relative(o: zappar_world_tracker_t, indx: number, mirror: boolean): Float32Array;
    world_tracker_plane_anchor_pose(o: zappar_world_tracker_t, indx: number, camera_pose: Float32Array, mirror: boolean): Float32Array;
    world_tracker_plane_anchor_polygon_data_size(o: zappar_world_tracker_t, indx: number): number;
    world_tracker_plane_anchor_polygon_data(o: zappar_world_tracker_t, indx: number): Float32Array;
    world_tracker_plane_anchor_polygon_version(o: zappar_world_tracker_t, indx: number): number;
    world_tracker_plane_anchor_orientation(o: zappar_world_tracker_t, indx: number): plane_orientation_t;
    world_tracker_world_anchor_status(o: zappar_world_tracker_t): anchor_status_t;
    world_tracker_world_anchor_id(o: zappar_world_tracker_t): string;
    world_tracker_world_anchor_pose_raw(o: zappar_world_tracker_t): Float32Array;
    world_tracker_world_anchor_pose_camera_relative(o: zappar_world_tracker_t, mirror: boolean): Float32Array;
    world_tracker_world_anchor_pose(o: zappar_world_tracker_t, camera_pose: Float32Array, mirror: boolean): Float32Array;
    world_tracker_ground_anchor_id(o: zappar_world_tracker_t): string;
    world_tracker_ground_anchor_status(o: zappar_world_tracker_t): anchor_status_t;
    world_tracker_ground_anchor_pose_raw(o: zappar_world_tracker_t): Float32Array;
    world_tracker_ground_anchor_pose_camera_relative(o: zappar_world_tracker_t, mirror: boolean): Float32Array;
    world_tracker_ground_anchor_pose(o: zappar_world_tracker_t, camera_pose: Float32Array, mirror: boolean): Float32Array;
    world_tracker_reset(o: zappar_world_tracker_t): void;
    world_tracker_tracks_data_enabled(o: zappar_world_tracker_t): boolean;
    world_tracker_tracks_data_enabled_set(o: zappar_world_tracker_t, tracks_data_enabled: boolean): void;
    world_tracker_tracks_data_size(o: zappar_world_tracker_t): number;
    world_tracker_tracks_data(o: zappar_world_tracker_t): Float32Array;
    world_tracker_tracks_type_data_size(o: zappar_world_tracker_t): number;
    world_tracker_tracks_type_data(o: zappar_world_tracker_t): Uint8Array;
    world_tracker_projections_data_enabled(o: zappar_world_tracker_t): boolean;
    world_tracker_projections_data_enabled_set(o: zappar_world_tracker_t, projections_data_enabled: boolean): void;
    world_tracker_projections_data_size(o: zappar_world_tracker_t): number;
    world_tracker_projections_data(o: zappar_world_tracker_t): Float32Array;
    world_tracker_mesh_anchors_enabled(o: zappar_world_tracker_t): boolean;
    world_tracker_mesh_anchors_enabled_set(o: zappar_world_tracker_t, mesh_anchors_enabled: boolean): void;
    world_tracker_mesh_anchor_count(o: zappar_world_tracker_t): number;
    world_tracker_mesh_anchor_id(o: zappar_world_tracker_t, indx: number): string;
    world_tracker_mesh_anchor_status(o: zappar_world_tracker_t, indx: number): anchor_status_t;
    world_tracker_mesh_anchor_pose_raw(o: zappar_world_tracker_t, indx: number): Float32Array;
    world_tracker_mesh_anchor_pose_camera_relative(o: zappar_world_tracker_t, indx: number, mirror: boolean): Float32Array;
    world_tracker_mesh_anchor_pose(o: zappar_world_tracker_t, indx: number, camera_pose: Float32Array, mirror: boolean): Float32Array;
    world_tracker_mesh_anchor_vertices(o: zappar_world_tracker_t, indx: number): Float32Array;
    world_tracker_mesh_anchor_vertices_offset(o: zappar_world_tracker_t, indx: number): number;
    world_tracker_mesh_anchor_vertices_stride(o: zappar_world_tracker_t, indx: number): number;
    world_tracker_mesh_anchor_vertices_count(o: zappar_world_tracker_t, indx: number): number;
    world_tracker_mesh_anchor_vertices_size(o: zappar_world_tracker_t, indx: number): number;
    world_tracker_mesh_anchor_indices(o: zappar_world_tracker_t, indx: number): Uint32Array;
    world_tracker_mesh_anchor_indices_count(o: zappar_world_tracker_t, indx: number): number;
    world_tracker_mesh_anchor_indices_size(o: zappar_world_tracker_t, indx: number): number;
    custom_anchor_create(pipeline: zappar_pipeline_t, worldtracker: zappar_world_tracker_t, id: string): zappar_custom_anchor_t;
    custom_anchor_destroy(o: zappar_custom_anchor_t): void;
    custom_anchor_id(o: zappar_custom_anchor_t): string;
    custom_anchor_status(o: zappar_custom_anchor_t): anchor_status_t;
    custom_anchor_pose_version(o: zappar_custom_anchor_t): number;
    custom_anchor_pose_raw(o: zappar_custom_anchor_t): Float32Array;
    custom_anchor_pose_camera_relative(o: zappar_custom_anchor_t, mirror: boolean): Float32Array;
    custom_anchor_pose(o: zappar_custom_anchor_t, camera_pose: Float32Array, mirror: boolean): Float32Array;
    custom_anchor_pose_set_from_camera_offset_raw(o: zappar_custom_anchor_t, x: number, y: number, z: number, orientation: transform_orientation_t): void;
    custom_anchor_pose_set_from_camera_offset(o: zappar_custom_anchor_t, x: number, y: number, z: number, orientation: transform_orientation_t): void;
    custom_anchor_pose_set_from_anchor_offset(o: zappar_custom_anchor_t, anchor_id: string, x: number, y: number, z: number, orientation: transform_orientation_t): void;
    custom_anchor_pose_set(o: zappar_custom_anchor_t, pose: Float32Array): void;
    custom_anchor_pose_set_with_parent(o: zappar_custom_anchor_t, pose: Float32Array, anchor_id: string): void;
    d3_tracker_create(pipeline: zappar_pipeline_t): zappar_d3_tracker_t;
    d3_tracker_destroy(o: zappar_d3_tracker_t): void;
    d3_tracker_id(o: zappar_d3_tracker_t, indx: number): string;
    d3_tracker_enabled(o: zappar_d3_tracker_t): boolean;
    d3_tracker_enabled_set(o: zappar_d3_tracker_t, enabled: boolean): void;
    d3_tracker_process_max_resolution_set(o: zappar_d3_tracker_t, v: boolean): void;
    d3_tracker_count(o: zappar_d3_tracker_t): number;
    d3_tracker_qr(o: zappar_d3_tracker_t, indx: number): string;
    d3_tracker_pose_raw(o: zappar_d3_tracker_t, indx: number): Float32Array;
    d3_tracker_pose_camera_relative(o: zappar_d3_tracker_t, indx: number, mirror: boolean): Float32Array;
    d3_tracker_pose(o: zappar_d3_tracker_t, indx: number, camera_pose: Float32Array, mirror: boolean): Float32Array;
    d3_tracker_pose0_raw(o: zappar_d3_tracker_t, indx: number): Float32Array;
    d3_tracker_pose0_camera_relative(o: zappar_d3_tracker_t, indx: number, mirror: boolean): Float32Array;
    d3_tracker_pose0(o: zappar_d3_tracker_t, indx: number, camera_pose: Float32Array, mirror: boolean): Float32Array;
    d3_tracker_pose1_raw(o: zappar_d3_tracker_t, indx: number): Float32Array;
    d3_tracker_pose1_camera_relative(o: zappar_d3_tracker_t, indx: number, mirror: boolean): Float32Array;
    d3_tracker_pose1(o: zappar_d3_tracker_t, indx: number, camera_pose: Float32Array, mirror: boolean): Float32Array;
    d3_tracker_landmarks_data(o: zappar_d3_tracker_t, indx: number): Float32Array;
    d3_tracker_landmarks_data_size(o: zappar_d3_tracker_t, indx: number): number;
    d3_tracker_type(o: zappar_d3_tracker_t, indx: number): number;
    d3_tracker_dense(o: zappar_d3_tracker_t, indx: number): number;
    d3_tracker_category(o: zappar_d3_tracker_t, indx: number): number;
    d3_tracker_size_for_id_set(o: zappar_d3_tracker_t, id: string, size: number): void;
}
