import { MessageSerializer } from "../serializer";
import { MessageDeserializer } from "../deserializer";
export class zappar_server {
    constructor(_impl, _sender) {
        this._impl = _impl;
        this._sender = _sender;
        this._deserializer = new MessageDeserializer();
        this.serializersByPipelineId = new Map();
        this._pipeline_id_by_pipeline_id = new Map();
        this._pipeline_by_instance = new Map();
        this._pipeline_id_by_camera_source_id = new Map();
        this._camera_source_by_instance = new Map();
        this._pipeline_id_by_sequence_source_id = new Map();
        this._sequence_source_by_instance = new Map();
        this._pipeline_id_by_image_tracker_id = new Map();
        this._image_tracker_by_instance = new Map();
        this._pipeline_id_by_face_tracker_id = new Map();
        this._face_tracker_by_instance = new Map();
        this._pipeline_id_by_face_mesh_id = new Map();
        this._face_mesh_by_instance = new Map();
        this._pipeline_id_by_face_landmark_id = new Map();
        this._face_landmark_by_instance = new Map();
        this._pipeline_id_by_barcode_finder_id = new Map();
        this._barcode_finder_by_instance = new Map();
        this._pipeline_id_by_instant_world_tracker_id = new Map();
        this._instant_world_tracker_by_instance = new Map();
        this._pipeline_id_by_zapcode_tracker_id = new Map();
        this._zapcode_tracker_by_instance = new Map();
        this._pipeline_id_by_world_tracker_id = new Map();
        this._world_tracker_by_instance = new Map();
        this._pipeline_id_by_custom_anchor_id = new Map();
        this._custom_anchor_by_instance = new Map();
        this._pipeline_id_by_d3_tracker_id = new Map();
        this._d3_tracker_by_instance = new Map();
    }
    processBuffer(b) {
        this._deserializer.setData(b);
        this._deserializer.forMessages((messageId, msg) => {
            switch (messageId) {
                case 39: {
                    this._impl.log_level_set(msg.logLevel());
                    break;
                }
                case 36: {
                    this._impl.analytics_project_id_set(msg.string(), msg.string());
                    break;
                }
                case 32: {
                    let clientId = msg.type();
                    let handle = this._impl.pipeline_create();
                    this._pipeline_by_instance.set(clientId, handle);
                    this._pipeline_id_by_pipeline_id.set(clientId, clientId);
                    this.serializersByPipelineId.set(clientId, new MessageSerializer(ab => {
                        this._sender(clientId, ab);
                    }));
                    break;
                }
                case 33: {
                    let clientId = msg.type();
                    let obj = this._pipeline_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.pipeline_destroy(obj);
                    this._pipeline_by_instance.delete(clientId);
                    break;
                }
                case 9: {
                    let clientId = msg.type();
                    let obj = this._pipeline_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.pipeline_frame_update(obj);
                    break;
                }
                case 63: {
                    let clientId = msg.type();
                    let obj = this._pipeline_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.pipeline_camera_frame_sharpness_enabled_set(obj, msg.bool());
                    break;
                }
                case 8: {
                    let clientId = msg.type();
                    let obj = this._pipeline_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.pipeline_camera_frame_submit(obj, msg.dataWithLength(), msg.int(), msg.int(), msg.int(), msg.matrix4x4(), msg.cameraModel(), msg.bool(), msg.int());
                    break;
                }
                case 10: {
                    let clientId = msg.type();
                    let obj = this._pipeline_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.pipeline_motion_accelerometer_submit(obj, msg.timestamp(), msg.float(), msg.float(), msg.float());
                    break;
                }
                case 12: {
                    let clientId = msg.type();
                    let obj = this._pipeline_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.pipeline_motion_accelerometer_with_gravity_submit_int(obj, msg.timestamp(), msg.timestamp(), msg.float(), msg.float(), msg.float());
                    break;
                }
                case 11: {
                    let clientId = msg.type();
                    let obj = this._pipeline_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.pipeline_motion_accelerometer_without_gravity_submit_int(obj, msg.timestamp(), msg.timestamp(), msg.float(), msg.float(), msg.float());
                    break;
                }
                case 15: {
                    let clientId = msg.type();
                    let obj = this._pipeline_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.pipeline_motion_rotation_rate_submit(obj, msg.timestamp(), msg.float(), msg.float(), msg.float());
                    break;
                }
                case 13: {
                    let clientId = msg.type();
                    let obj = this._pipeline_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.pipeline_motion_rotation_rate_submit_int(obj, msg.timestamp(), msg.timestamp(), msg.float(), msg.float(), msg.float());
                    break;
                }
                case 16: {
                    let clientId = msg.type();
                    let obj = this._pipeline_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.pipeline_motion_attitude_submit(obj, msg.timestamp(), msg.float(), msg.float(), msg.float());
                    break;
                }
                case 14: {
                    let clientId = msg.type();
                    let obj = this._pipeline_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.pipeline_motion_attitude_submit_int(obj, msg.timestamp(), msg.timestamp(), msg.float(), msg.float(), msg.float());
                    break;
                }
                case 17: {
                    let clientId = msg.type();
                    let obj = this._pipeline_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.pipeline_motion_relative_orientation_submit_int(obj, msg.timestamp(), msg.timestamp(), msg.float(), msg.float(), msg.float(), msg.float());
                    break;
                }
                case 18: {
                    let clientId = msg.type();
                    let obj = this._pipeline_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.pipeline_motion_attitude_matrix_submit(obj, msg.matrix4x4());
                    break;
                }
                case 34: {
                    let clientId = msg.type();
                    let arg_pipeline_id = msg.type();
                    let arg_pipeline = this._pipeline_by_instance.get(arg_pipeline_id);
                    let arg_device_id = msg.string();
                    let handle = this._impl.camera_source_create(arg_pipeline, arg_device_id);
                    this._camera_source_by_instance.set(clientId, handle);
                    this._pipeline_id_by_camera_source_id.set(clientId, arg_pipeline_id);
                    break;
                }
                case 35: {
                    let clientId = msg.type();
                    let obj = this._camera_source_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.camera_source_destroy(obj);
                    this._camera_source_by_instance.delete(clientId);
                    break;
                }
                case 40: {
                    let clientId = msg.type();
                    let arg_pipeline_id = msg.type();
                    let arg_pipeline = this._pipeline_by_instance.get(arg_pipeline_id);
                    let handle = this._impl.sequence_source_create(arg_pipeline);
                    this._sequence_source_by_instance.set(clientId, handle);
                    this._pipeline_id_by_sequence_source_id.set(clientId, arg_pipeline_id);
                    break;
                }
                case 41: {
                    let clientId = msg.type();
                    let obj = this._sequence_source_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.sequence_source_destroy(obj);
                    this._sequence_source_by_instance.delete(clientId);
                    break;
                }
                case 2: {
                    let clientId = msg.type();
                    let arg_pipeline_id = msg.type();
                    let arg_pipeline = this._pipeline_by_instance.get(arg_pipeline_id);
                    let handle = this._impl.image_tracker_create(arg_pipeline);
                    this._image_tracker_by_instance.set(clientId, handle);
                    this._pipeline_id_by_image_tracker_id.set(clientId, arg_pipeline_id);
                    break;
                }
                case 19: {
                    let clientId = msg.type();
                    let obj = this._image_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.image_tracker_destroy(obj);
                    this._image_tracker_by_instance.delete(clientId);
                    break;
                }
                case 4: {
                    let clientId = msg.type();
                    let obj = this._image_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.image_tracker_target_load_from_memory(obj, msg.dataWithLength());
                    break;
                }
                case 3: {
                    let clientId = msg.type();
                    let obj = this._image_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.image_tracker_enabled_set(obj, msg.bool());
                    break;
                }
                case 25: {
                    let clientId = msg.type();
                    let arg_pipeline_id = msg.type();
                    let arg_pipeline = this._pipeline_by_instance.get(arg_pipeline_id);
                    let handle = this._impl.face_tracker_create(arg_pipeline);
                    this._face_tracker_by_instance.set(clientId, handle);
                    this._pipeline_id_by_face_tracker_id.set(clientId, arg_pipeline_id);
                    break;
                }
                case 26: {
                    let clientId = msg.type();
                    let obj = this._face_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.face_tracker_destroy(obj);
                    this._face_tracker_by_instance.delete(clientId);
                    break;
                }
                case 27: {
                    let clientId = msg.type();
                    let obj = this._face_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.face_tracker_model_load_from_memory(obj, msg.dataWithLength());
                    break;
                }
                case 28: {
                    let clientId = msg.type();
                    let obj = this._face_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.face_tracker_enabled_set(obj, msg.bool());
                    break;
                }
                case 29: {
                    let clientId = msg.type();
                    let obj = this._face_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.face_tracker_max_faces_set(obj, msg.int());
                    break;
                }
                case 30: {
                    let clientId = msg.type();
                    let handle = this._impl.face_mesh_create();
                    this._face_mesh_by_instance.set(clientId, handle);
                    break;
                }
                case 31: {
                    let clientId = msg.type();
                    let obj = this._face_mesh_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.face_mesh_destroy(obj);
                    this._face_mesh_by_instance.delete(clientId);
                    break;
                }
                case 37: {
                    let clientId = msg.type();
                    let arg_landmark = msg.faceLandmarkName();
                    let handle = this._impl.face_landmark_create(arg_landmark);
                    this._face_landmark_by_instance.set(clientId, handle);
                    break;
                }
                case 38: {
                    let clientId = msg.type();
                    let obj = this._face_landmark_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.face_landmark_destroy(obj);
                    this._face_landmark_by_instance.delete(clientId);
                    break;
                }
                case 21: {
                    let clientId = msg.type();
                    let arg_pipeline_id = msg.type();
                    let arg_pipeline = this._pipeline_by_instance.get(arg_pipeline_id);
                    let handle = this._impl.barcode_finder_create(arg_pipeline);
                    this._barcode_finder_by_instance.set(clientId, handle);
                    this._pipeline_id_by_barcode_finder_id.set(clientId, arg_pipeline_id);
                    break;
                }
                case 22: {
                    let clientId = msg.type();
                    let obj = this._barcode_finder_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.barcode_finder_destroy(obj);
                    this._barcode_finder_by_instance.delete(clientId);
                    break;
                }
                case 23: {
                    let clientId = msg.type();
                    let obj = this._barcode_finder_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.barcode_finder_enabled_set(obj, msg.bool());
                    break;
                }
                case 24: {
                    let clientId = msg.type();
                    let obj = this._barcode_finder_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.barcode_finder_formats_set(obj, msg.barcodeFormat());
                    break;
                }
                case 5: {
                    let clientId = msg.type();
                    let arg_pipeline_id = msg.type();
                    let arg_pipeline = this._pipeline_by_instance.get(arg_pipeline_id);
                    let handle = this._impl.instant_world_tracker_create(arg_pipeline);
                    this._instant_world_tracker_by_instance.set(clientId, handle);
                    this._pipeline_id_by_instant_world_tracker_id.set(clientId, arg_pipeline_id);
                    break;
                }
                case 20: {
                    let clientId = msg.type();
                    let obj = this._instant_world_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.instant_world_tracker_destroy(obj);
                    this._instant_world_tracker_by_instance.delete(clientId);
                    break;
                }
                case 6: {
                    let clientId = msg.type();
                    let obj = this._instant_world_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.instant_world_tracker_enabled_set(obj, msg.bool());
                    break;
                }
                case 7: {
                    let clientId = msg.type();
                    let obj = this._instant_world_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.instant_world_tracker_anchor_pose_set_from_camera_offset_raw(obj, msg.float(), msg.float(), msg.float(), msg.instantTrackerTransformOrientation());
                    break;
                }
                case 42: {
                    let clientId = msg.type();
                    let arg_pipeline_id = msg.type();
                    let arg_pipeline = this._pipeline_by_instance.get(arg_pipeline_id);
                    let handle = this._impl.zapcode_tracker_create(arg_pipeline);
                    this._zapcode_tracker_by_instance.set(clientId, handle);
                    this._pipeline_id_by_zapcode_tracker_id.set(clientId, arg_pipeline_id);
                    break;
                }
                case 45: {
                    let clientId = msg.type();
                    let obj = this._zapcode_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.zapcode_tracker_destroy(obj);
                    this._zapcode_tracker_by_instance.delete(clientId);
                    break;
                }
                case 44: {
                    let clientId = msg.type();
                    let obj = this._zapcode_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.zapcode_tracker_target_load_from_memory(obj, msg.dataWithLength());
                    break;
                }
                case 43: {
                    let clientId = msg.type();
                    let obj = this._zapcode_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.zapcode_tracker_enabled_set(obj, msg.bool());
                    break;
                }
                case 46: {
                    let clientId = msg.type();
                    let arg_pipeline_id = msg.type();
                    let arg_pipeline = this._pipeline_by_instance.get(arg_pipeline_id);
                    let handle = this._impl.world_tracker_create(arg_pipeline);
                    this._world_tracker_by_instance.set(clientId, handle);
                    this._pipeline_id_by_world_tracker_id.set(clientId, arg_pipeline_id);
                    break;
                }
                case 47: {
                    let clientId = msg.type();
                    let obj = this._world_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.world_tracker_destroy(obj);
                    this._world_tracker_by_instance.delete(clientId);
                    break;
                }
                case 48: {
                    let clientId = msg.type();
                    let obj = this._world_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.world_tracker_enabled_set(obj, msg.bool());
                    break;
                }
                case 62: {
                    let clientId = msg.type();
                    let obj = this._world_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.world_tracker_scale_mode_set(obj, msg.worldScaleMode());
                    break;
                }
                case 49: {
                    let clientId = msg.type();
                    let obj = this._world_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.world_tracker_horizontal_plane_detection_enabled_set(obj, msg.bool());
                    break;
                }
                case 50: {
                    let clientId = msg.type();
                    let obj = this._world_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.world_tracker_vertical_plane_detection_enabled_set(obj, msg.bool());
                    break;
                }
                case 51: {
                    let clientId = msg.type();
                    let obj = this._world_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.world_tracker_reset(obj);
                    break;
                }
                case 52: {
                    let clientId = msg.type();
                    let obj = this._world_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.world_tracker_tracks_data_enabled_set(obj, msg.bool());
                    break;
                }
                case 53: {
                    let clientId = msg.type();
                    let obj = this._world_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.world_tracker_projections_data_enabled_set(obj, msg.bool());
                    break;
                }
                case 54: {
                    let clientId = msg.type();
                    let arg_pipeline_id = msg.type();
                    let arg_pipeline = this._pipeline_by_instance.get(arg_pipeline_id);
                    let arg_worldtracker_id = msg.type();
                    let arg_worldtracker = this._world_tracker_by_instance.get(arg_worldtracker_id);
                    let arg_id = msg.string();
                    let handle = this._impl.custom_anchor_create(arg_pipeline, arg_worldtracker, arg_id);
                    this._custom_anchor_by_instance.set(clientId, handle);
                    this._pipeline_id_by_custom_anchor_id.set(clientId, arg_pipeline_id);
                    break;
                }
                case 55: {
                    let clientId = msg.type();
                    let obj = this._custom_anchor_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.custom_anchor_destroy(obj);
                    this._custom_anchor_by_instance.delete(clientId);
                    break;
                }
                case 56: {
                    let clientId = msg.type();
                    let obj = this._custom_anchor_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.custom_anchor_pose_set_from_camera_offset_raw(obj, msg.float(), msg.float(), msg.float(), msg.transformOrientation());
                    break;
                }
                case 57: {
                    let clientId = msg.type();
                    let obj = this._custom_anchor_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.custom_anchor_pose_set_from_anchor_offset(obj, msg.string(), msg.float(), msg.float(), msg.float(), msg.transformOrientation());
                    break;
                }
                case 58: {
                    let clientId = msg.type();
                    let obj = this._custom_anchor_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.custom_anchor_pose_set(obj, msg.matrix4x4());
                    break;
                }
                case 59: {
                    let clientId = msg.type();
                    let obj = this._custom_anchor_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.custom_anchor_pose_set_with_parent(obj, msg.matrix4x4(), msg.string());
                    break;
                }
                case 60: {
                    let clientId = msg.type();
                    let arg_pipeline_id = msg.type();
                    let arg_pipeline = this._pipeline_by_instance.get(arg_pipeline_id);
                    let handle = this._impl.d3_tracker_create(arg_pipeline);
                    this._d3_tracker_by_instance.set(clientId, handle);
                    this._pipeline_id_by_d3_tracker_id.set(clientId, arg_pipeline_id);
                    break;
                }
                case 61: {
                    let clientId = msg.type();
                    let obj = this._d3_tracker_by_instance.get(clientId);
                    if (obj === undefined)
                        return;
                    this._impl.d3_tracker_destroy(obj);
                    this._d3_tracker_by_instance.delete(clientId);
                    break;
                }
            }
        });
    }
    exploreState() {
        for (let [k, v] of this._pipeline_by_instance) {
            let pipeline = this._pipeline_id_by_pipeline_id.get(k);
            if (!pipeline)
                continue;
            let serializer = this.serializersByPipelineId.get(pipeline);
            if (!serializer)
                continue;
            serializer.sendMessage(10, msg => {
                msg.type(k);
                msg.int(this._impl.pipeline_frame_number(v));
            });
            serializer.sendMessage(6, msg => {
                msg.type(k);
                msg.cameraModel(this._impl.pipeline_camera_model(v));
            });
            serializer.sendMessage(7, msg => {
                msg.type(k);
                msg.int(this._impl.pipeline_camera_data_width(v));
            });
            serializer.sendMessage(8, msg => {
                msg.type(k);
                msg.int(this._impl.pipeline_camera_data_height(v));
            });
            serializer.sendMessage(9, msg => {
                msg.type(k);
                msg.float(this._impl.pipeline_camera_frame_sharpness(v));
            });
            serializer.sendMessage(5, msg => {
                msg.type(k);
                msg.int(this._impl.pipeline_camera_frame_user_data(v));
            });
            serializer.sendMessage(14, msg => {
                msg.type(k);
                msg.matrix4x4(this._impl.pipeline_camera_frame_camera_attitude(v));
            });
            serializer.sendMessage(15, msg => {
                msg.type(k);
                msg.matrix4x4(this._impl.pipeline_camera_frame_device_attitude(v));
            });
        }
        for (let [k, v] of this._camera_source_by_instance) {
            let pipeline = this._pipeline_id_by_camera_source_id.get(k);
            if (!pipeline)
                continue;
            let serializer = this.serializersByPipelineId.get(pipeline);
            if (!serializer)
                continue;
        }
        for (let [k, v] of this._sequence_source_by_instance) {
            let pipeline = this._pipeline_id_by_sequence_source_id.get(k);
            if (!pipeline)
                continue;
            let serializer = this.serializersByPipelineId.get(pipeline);
            if (!serializer)
                continue;
        }
        for (let [k, v] of this._image_tracker_by_instance) {
            let pipeline = this._pipeline_id_by_image_tracker_id.get(k);
            if (!pipeline)
                continue;
            let serializer = this.serializersByPipelineId.get(pipeline);
            if (!serializer)
                continue;
            serializer.sendMessage(22, msg => {
                msg.type(k);
                msg.int(this._impl.image_tracker_target_loaded_version(v));
            });
            serializer.sendMessage(1, msg => {
                msg.type(k);
                msg.int(this._impl.image_tracker_anchor_count(v));
            });
            for (let i = 0; i < this._impl.image_tracker_anchor_count(v); i++) {
                serializer.sendMessage(2, msg => {
                    msg.type(k);
                    msg.int(i);
                    msg.string(this._impl.image_tracker_anchor_id(v, i));
                });
            }
            for (let i = 0; i < this._impl.image_tracker_anchor_count(v); i++) {
                serializer.sendMessage(3, msg => {
                    msg.type(k);
                    msg.int(i);
                    msg.matrix4x4(this._impl.image_tracker_anchor_pose_raw(v, i));
                });
            }
        }
        for (let [k, v] of this._face_tracker_by_instance) {
            let pipeline = this._pipeline_id_by_face_tracker_id.get(k);
            if (!pipeline)
                continue;
            let serializer = this.serializersByPipelineId.get(pipeline);
            if (!serializer)
                continue;
            serializer.sendMessage(21, msg => {
                msg.type(k);
                msg.int(this._impl.face_tracker_model_loaded_version(v));
            });
            serializer.sendMessage(16, msg => {
                msg.type(k);
                msg.int(this._impl.face_tracker_anchor_count(v));
            });
            for (let i = 0; i < this._impl.face_tracker_anchor_count(v); i++) {
                serializer.sendMessage(17, msg => {
                    msg.type(k);
                    msg.int(i);
                    msg.string(this._impl.face_tracker_anchor_id(v, i));
                });
            }
            for (let i = 0; i < this._impl.face_tracker_anchor_count(v); i++) {
                serializer.sendMessage(18, msg => {
                    msg.type(k);
                    msg.int(i);
                    msg.matrix4x4(this._impl.face_tracker_anchor_pose_raw(v, i));
                });
            }
            for (let i = 0; i < this._impl.face_tracker_anchor_count(v); i++) {
                serializer.sendMessage(19, msg => {
                    msg.type(k);
                    msg.int(i);
                    msg.identityCoefficients(this._impl.face_tracker_anchor_identity_coefficients(v, i));
                });
            }
            for (let i = 0; i < this._impl.face_tracker_anchor_count(v); i++) {
                serializer.sendMessage(20, msg => {
                    msg.type(k);
                    msg.int(i);
                    msg.expressionCoefficients(this._impl.face_tracker_anchor_expression_coefficients(v, i));
                });
            }
        }
        for (let [k, v] of this._face_mesh_by_instance) {
            let pipeline = this._pipeline_id_by_face_mesh_id.get(k);
            if (!pipeline)
                continue;
            let serializer = this.serializersByPipelineId.get(pipeline);
            if (!serializer)
                continue;
        }
        for (let [k, v] of this._face_landmark_by_instance) {
            let pipeline = this._pipeline_id_by_face_landmark_id.get(k);
            if (!pipeline)
                continue;
            let serializer = this.serializersByPipelineId.get(pipeline);
            if (!serializer)
                continue;
        }
        for (let [k, v] of this._barcode_finder_by_instance) {
            let pipeline = this._pipeline_id_by_barcode_finder_id.get(k);
            if (!pipeline)
                continue;
            let serializer = this.serializersByPipelineId.get(pipeline);
            if (!serializer)
                continue;
            serializer.sendMessage(11, msg => {
                msg.type(k);
                msg.int(this._impl.barcode_finder_found_number(v));
            });
            for (let i = 0; i < this._impl.barcode_finder_found_number(v); i++) {
                serializer.sendMessage(12, msg => {
                    msg.type(k);
                    msg.int(i);
                    msg.string(this._impl.barcode_finder_found_text(v, i));
                });
            }
            for (let i = 0; i < this._impl.barcode_finder_found_number(v); i++) {
                serializer.sendMessage(13, msg => {
                    msg.type(k);
                    msg.int(i);
                    msg.barcodeFormat(this._impl.barcode_finder_found_format(v, i));
                });
            }
        }
        for (let [k, v] of this._instant_world_tracker_by_instance) {
            let pipeline = this._pipeline_id_by_instant_world_tracker_id.get(k);
            if (!pipeline)
                continue;
            let serializer = this.serializersByPipelineId.get(pipeline);
            if (!serializer)
                continue;
            serializer.sendMessage(4, msg => {
                msg.type(k);
                msg.matrix4x4(this._impl.instant_world_tracker_anchor_pose_raw(v));
            });
        }
        for (let [k, v] of this._zapcode_tracker_by_instance) {
            let pipeline = this._pipeline_id_by_zapcode_tracker_id.get(k);
            if (!pipeline)
                continue;
            let serializer = this.serializersByPipelineId.get(pipeline);
            if (!serializer)
                continue;
            serializer.sendMessage(27, msg => {
                msg.type(k);
                msg.int(this._impl.zapcode_tracker_target_loaded_version(v));
            });
            serializer.sendMessage(24, msg => {
                msg.type(k);
                msg.int(this._impl.zapcode_tracker_anchor_count(v));
            });
            for (let i = 0; i < this._impl.zapcode_tracker_anchor_count(v); i++) {
                serializer.sendMessage(25, msg => {
                    msg.type(k);
                    msg.int(i);
                    msg.string(this._impl.zapcode_tracker_anchor_id(v, i));
                });
            }
            for (let i = 0; i < this._impl.zapcode_tracker_anchor_count(v); i++) {
                serializer.sendMessage(26, msg => {
                    msg.type(k);
                    msg.int(i);
                    msg.matrix4x4(this._impl.zapcode_tracker_anchor_pose_raw(v, i));
                });
            }
        }
        for (let [k, v] of this._world_tracker_by_instance) {
            let pipeline = this._pipeline_id_by_world_tracker_id.get(k);
            if (!pipeline)
                continue;
            let serializer = this.serializersByPipelineId.get(pipeline);
            if (!serializer)
                continue;
            serializer.sendMessage(28, msg => {
                msg.type(k);
                msg.int(this._impl.world_tracker_session_number(v));
            });
            serializer.sendMessage(44, msg => {
                msg.type(k);
                msg.int(this._impl.world_tracker_quality(v));
            });
            serializer.sendMessage(29, msg => {
                msg.type(k);
                msg.int(this._impl.world_tracker_plane_anchor_count(v));
            });
            for (let i = 0; i < this._impl.world_tracker_plane_anchor_count(v); i++) {
                serializer.sendMessage(37, msg => {
                    msg.type(k);
                    msg.int(i);
                    msg.string(this._impl.world_tracker_plane_anchor_id(v, i));
                });
            }
            for (let i = 0; i < this._impl.world_tracker_plane_anchor_count(v); i++) {
                serializer.sendMessage(30, msg => {
                    msg.type(k);
                    msg.int(i);
                    msg.matrix4x4(this._impl.world_tracker_plane_anchor_pose_raw(v, i));
                });
            }
            for (let i = 0; i < this._impl.world_tracker_plane_anchor_count(v); i++) {
                serializer.sendMessage(32, msg => {
                    msg.type(k);
                    msg.int(i);
                    msg.anchorStatus(this._impl.world_tracker_plane_anchor_status(v, i));
                });
            }
            for (let i = 0; i < this._impl.world_tracker_plane_anchor_count(v); i++) {
                serializer.sendMessage(33, msg => {
                    msg.type(k);
                    msg.int(i);
                    msg.int(this._impl.world_tracker_plane_anchor_polygon_data_size(v, i));
                });
            }
            for (let i = 0; i < this._impl.world_tracker_plane_anchor_count(v); i++) {
                serializer.sendMessage(34, msg => {
                    msg.type(k);
                    msg.int(i);
                    msg.floatArray(this._impl.world_tracker_plane_anchor_polygon_data(v, i));
                });
            }
            for (let i = 0; i < this._impl.world_tracker_plane_anchor_count(v); i++) {
                serializer.sendMessage(35, msg => {
                    msg.type(k);
                    msg.int(i);
                    msg.int(this._impl.world_tracker_plane_anchor_polygon_version(v, i));
                });
            }
            for (let i = 0; i < this._impl.world_tracker_plane_anchor_count(v); i++) {
                serializer.sendMessage(36, msg => {
                    msg.type(k);
                    msg.int(i);
                    msg.planeOrientation(this._impl.world_tracker_plane_anchor_orientation(v, i));
                });
            }
            serializer.sendMessage(40, msg => {
                msg.type(k);
                msg.anchorStatus(this._impl.world_tracker_world_anchor_status(v));
            });
            serializer.sendMessage(39, msg => {
                msg.type(k);
                msg.string(this._impl.world_tracker_world_anchor_id(v));
            });
            serializer.sendMessage(38, msg => {
                msg.type(k);
                msg.matrix4x4(this._impl.world_tracker_world_anchor_pose_raw(v));
            });
            serializer.sendMessage(42, msg => {
                msg.type(k);
                msg.string(this._impl.world_tracker_ground_anchor_id(v));
            });
            serializer.sendMessage(43, msg => {
                msg.type(k);
                msg.anchorStatus(this._impl.world_tracker_ground_anchor_status(v));
            });
            serializer.sendMessage(41, msg => {
                msg.type(k);
                msg.matrix4x4(this._impl.world_tracker_ground_anchor_pose_raw(v));
            });
            serializer.sendMessage(47, msg => {
                msg.type(k);
                msg.int(this._impl.world_tracker_tracks_data_size(v));
            });
            serializer.sendMessage(46, msg => {
                msg.type(k);
                msg.floatArray(this._impl.world_tracker_tracks_data(v));
            });
            serializer.sendMessage(49, msg => {
                msg.type(k);
                msg.int(this._impl.world_tracker_tracks_type_data_size(v));
            });
            serializer.sendMessage(48, msg => {
                msg.type(k);
                msg.ucharArray(this._impl.world_tracker_tracks_type_data(v));
            });
            serializer.sendMessage(52, msg => {
                msg.type(k);
                msg.int(this._impl.world_tracker_projections_data_size(v));
            });
            serializer.sendMessage(51, msg => {
                msg.type(k);
                msg.floatArray(this._impl.world_tracker_projections_data(v));
            });
        }
        for (let [k, v] of this._custom_anchor_by_instance) {
            let pipeline = this._pipeline_id_by_custom_anchor_id.get(k);
            if (!pipeline)
                continue;
            let serializer = this.serializersByPipelineId.get(pipeline);
            if (!serializer)
                continue;
            serializer.sendMessage(54, msg => {
                msg.type(k);
                msg.anchorStatus(this._impl.custom_anchor_status(v));
            });
            serializer.sendMessage(55, msg => {
                msg.type(k);
                msg.int(this._impl.custom_anchor_pose_version(v));
            });
            serializer.sendMessage(53, msg => {
                msg.type(k);
                msg.matrix4x4(this._impl.custom_anchor_pose_raw(v));
            });
        }
        for (let [k, v] of this._d3_tracker_by_instance) {
            let pipeline = this._pipeline_id_by_d3_tracker_id.get(k);
            if (!pipeline)
                continue;
            let serializer = this.serializersByPipelineId.get(pipeline);
            if (!serializer)
                continue;
        }
    }
}
