export declare enum barcode_format_t {
    UNKNOWN = 131072,
    AZTEC = 1,
    CODABAR = 2,
    CODE_39 = 4,
    CODE_93 = 8,
    CODE_128 = 16,
    DATA_MATRIX = 32,
    EAN_8 = 64,
    EAN_13 = 128,
    ITF = 256,
    MAXICODE = 512,
    PDF_417 = 1024,
    QR_CODE = 2048,
    RSS_14 = 4096,
    RSS_EXPANDED = 8192,
    UPC_A = 16384,
    UPC_E = 32768,
    UPC_EAN_EXTENSION = 65536,
    ALL = 131071
}
export declare enum face_landmark_name_t {
    EYE_LEFT = 0,
    EYE_RIGHT = 1,
    EAR_LEFT = 2,
    EAR_RIGHT = 3,
    NOSE_BRIDGE = 4,
    NOSE_TIP = 5,
    NOSE_BASE = 6,
    LIP_TOP = 7,
    LIP_BOTTOM = 8,
    MOUTH_CENTER = 9,
    CHIN = 10,
    EYEBROW_LEFT = 11,
    EYEBROW_RIGHT = 12
}
export declare enum instant_world_tracker_transform_orientation_t {
    WORLD = 3,
    MINUS_Z_AWAY_FROM_USER = 4,
    MINUS_Z_HEADING = 5,
    UNCHANGED = 6
}
export declare enum transform_orientation_t {
    UNCHANGED = 0,
    WORLD = 1,
    PARENT = 2,
    Z_TOWARDS_CAMERA = 3
}
export declare enum log_level_t {
    LOG_LEVEL_NONE = 0,
    LOG_LEVEL_ERROR = 1,
    LOG_LEVEL_WARNING = 2,
    LOG_LEVEL_VERBOSE = 3
}
export declare enum frame_pixel_format_t {
    FRAME_PIXEL_FORMAT_I420 = 0,
    FRAME_PIXEL_FORMAT_I420A = 1,
    FRAME_PIXEL_FORMAT_I422 = 2,
    FRAME_PIXEL_FORMAT_I444 = 3,
    FRAME_PIXEL_FORMAT_NV12 = 4,
    FRAME_PIXEL_FORMAT_RGBA = 5,
    FRAME_PIXEL_FORMAT_BGRA = 6,
    FRAME_PIXEL_FORMAT_Y = 7
}
export declare enum image_target_type_t {
    IMAGE_TRACKER_TYPE_PLANAR = 0,
    IMAGE_TRACKER_TYPE_CYLINDRICAL = 1,
    IMAGE_TRACKER_TYPE_CONICAL = 2
}
export declare enum world_tracker_quality_t {
    WORLD_TRACKER_QUALITY_INITIALIZING = 0,
    WORLD_TRACKER_QUALITY_GOOD = 1,
    WORLD_TRACKER_QUALITY_LIMITED = 2,
    WORLD_TRACKER_QUALITY_INACTIVE = 3
}
export declare enum anchor_status_t {
    ANCHOR_STATUS_INITIALIZING = 0,
    ANCHOR_STATUS_TRACKING = 1,
    ANCHOR_STATUS_PAUSED = 2,
    ANCHOR_STATUS_STOPPED = 3
}
export declare enum plane_orientation_t {
    PLANE_ORIENTATION_HORIZONTAL = 0,
    PLANE_ORIENTATION_VERTICAL = 1
}
export declare enum camera_profile_t {
    DEFAULT = 0,
    HIGH = 1
}
export declare enum world_scale_mode_t {
    DEFAULT = 0,
    ABSOLUTE = 1,
    MEDIAN = 2
}
export declare type zappar_pipeline_t = number & {
    _: 'zappar_pipeline_t';
};
export declare type zappar_camera_source_t = number & {
    _: 'zappar_camera_source_t';
};
export declare type zappar_sequence_source_t = number & {
    _: 'zappar_sequence_source_t';
};
export declare type zappar_image_tracker_t = number & {
    _: 'zappar_image_tracker_t';
};
export declare type zappar_face_tracker_t = number & {
    _: 'zappar_face_tracker_t';
};
export declare type zappar_face_mesh_t = number & {
    _: 'zappar_face_mesh_t';
};
export declare type zappar_face_landmark_t = number & {
    _: 'zappar_face_landmark_t';
};
export declare type zappar_barcode_finder_t = number & {
    _: 'zappar_barcode_finder_t';
};
export declare type zappar_instant_world_tracker_t = number & {
    _: 'zappar_instant_world_tracker_t';
};
export declare type zappar_zapcode_tracker_t = number & {
    _: 'zappar_zapcode_tracker_t';
};
export declare type zappar_world_tracker_t = number & {
    _: 'zappar_world_tracker_t';
};
export declare type zappar_custom_anchor_t = number & {
    _: 'zappar_custom_anchor_t';
};
export declare type zappar_d3_tracker_t = number & {
    _: 'zappar_d3_tracker_t';
};
export interface zappar_cwrap {
    log_level(): log_level_t;
    log_level_set(level: log_level_t): void;
    analytics_project_id_set(id: string, uid: string): void;
    pipeline_create(): zappar_pipeline_t;
    pipeline_destroy(o: zappar_pipeline_t): void;
    pipeline_camera_frame_data_raw(o: zappar_pipeline_t): number;
    pipeline_camera_frame_data_raw_size(o: zappar_pipeline_t): number;
    pipeline_frame_update(o: zappar_pipeline_t): void;
    pipeline_frame_number(o: zappar_pipeline_t): number;
    pipeline_camera_model(o: zappar_pipeline_t): Float32Array;
    pipeline_camera_data_width(o: zappar_pipeline_t): number;
    pipeline_camera_data_height(o: zappar_pipeline_t): number;
    pipeline_camera_frame_sharpness_enabled(o: zappar_pipeline_t): boolean;
    pipeline_camera_frame_sharpness_enabled_set(o: zappar_pipeline_t, val: boolean): void;
    pipeline_camera_frame_sharpness(o: zappar_pipeline_t): number;
    pipeline_camera_frame_user_data(o: zappar_pipeline_t): number;
    pipeline_camera_frame_submit(o: zappar_pipeline_t, data: ArrayBuffer, width: number, height: number, user_data: number, camera_to_device_transform: Float32Array, camera_model: Float32Array, user_facing: boolean, timestampMicroseconds: number): void;
    pipeline_camera_frame_submit_raw_pointer(o: zappar_pipeline_t, data: number, dataLength: number, format: frame_pixel_format_t, width: number, height: number, user_data: number, camera_to_device_transform: Float32Array, rotation: number, camera_model: Float32Array, user_facing: boolean, timestampMicroseconds: number, halfSample: boolean): void;
    pipeline_camera_frame_camera_attitude(o: zappar_pipeline_t): Float32Array;
    pipeline_camera_frame_device_attitude(o: zappar_pipeline_t): Float32Array;
    pipeline_motion_accelerometer_submit(o: zappar_pipeline_t, time: number, x: number, y: number, z: number): void;
    pipeline_motion_accelerometer_with_gravity_submit_int(o: zappar_pipeline_t, time: number, interval: number, x: number, y: number, z: number): void;
    pipeline_motion_accelerometer_without_gravity_submit_int(o: zappar_pipeline_t, time: number, interval: number, x: number, y: number, z: number): void;
    pipeline_motion_rotation_rate_submit(o: zappar_pipeline_t, time: number, x: number, y: number, z: number): void;
    pipeline_motion_rotation_rate_submit_int(o: zappar_pipeline_t, time: number, interval: number, x: number, y: number, z: number): void;
    pipeline_motion_attitude_submit(o: zappar_pipeline_t, time: number, x: number, y: number, z: number): void;
    pipeline_motion_attitude_submit_int(o: zappar_pipeline_t, time: number, interval: number, x: number, y: number, z: number): void;
    pipeline_motion_relative_orientation_submit_int(o: zappar_pipeline_t, time: number, interval: number, x: number, y: number, z: number, w: number): void;
    pipeline_motion_attitude_matrix_submit(o: zappar_pipeline_t, mat: Float32Array): void;
    camera_source_create(pipeline: zappar_pipeline_t, device_id: string): zappar_camera_source_t;
    camera_source_destroy(o: zappar_camera_source_t): void;
    sequence_source_create(pipeline: zappar_pipeline_t): zappar_sequence_source_t;
    sequence_source_destroy(o: zappar_sequence_source_t): void;
    image_tracker_create(pipeline: zappar_pipeline_t): zappar_image_tracker_t;
    image_tracker_destroy(o: zappar_image_tracker_t): void;
    image_tracker_target_load_from_memory(o: zappar_image_tracker_t, data: ArrayBuffer): void;
    image_tracker_target_loaded_version(o: zappar_image_tracker_t): number;
    image_tracker_enabled(o: zappar_image_tracker_t): boolean;
    image_tracker_enabled_set(o: zappar_image_tracker_t, enabled: boolean): void;
    image_tracker_anchor_count(o: zappar_image_tracker_t): number;
    image_tracker_anchor_id(o: zappar_image_tracker_t, indx: number): string;
    image_tracker_anchor_pose_raw(o: zappar_image_tracker_t, indx: number): Float32Array;
    face_tracker_create(pipeline: zappar_pipeline_t): zappar_face_tracker_t;
    face_tracker_destroy(o: zappar_face_tracker_t): void;
    face_tracker_model_load_from_memory(o: zappar_face_tracker_t, data: ArrayBuffer): void;
    face_tracker_model_loaded_version(o: zappar_face_tracker_t): number;
    face_tracker_enabled_set(o: zappar_face_tracker_t, enabled: boolean): void;
    face_tracker_enabled(o: zappar_face_tracker_t): boolean;
    face_tracker_max_faces_set(o: zappar_face_tracker_t, num: number): void;
    face_tracker_max_faces(o: zappar_face_tracker_t): number;
    face_tracker_anchor_count(o: zappar_face_tracker_t): number;
    face_tracker_anchor_id(o: zappar_face_tracker_t, indx: number): string;
    face_tracker_anchor_pose_raw(o: zappar_face_tracker_t, indx: number): Float32Array;
    face_tracker_anchor_identity_coefficients(o: zappar_face_tracker_t, indx: number): Float32Array;
    face_tracker_anchor_expression_coefficients(o: zappar_face_tracker_t, indx: number): Float32Array;
    face_mesh_create(): zappar_face_mesh_t;
    face_mesh_destroy(o: zappar_face_mesh_t): void;
    face_landmark_create(landmark: face_landmark_name_t): zappar_face_landmark_t;
    face_landmark_destroy(o: zappar_face_landmark_t): void;
    barcode_finder_create(pipeline: zappar_pipeline_t): zappar_barcode_finder_t;
    barcode_finder_destroy(o: zappar_barcode_finder_t): void;
    barcode_finder_enabled_set(o: zappar_barcode_finder_t, enabled: boolean): void;
    barcode_finder_enabled(o: zappar_barcode_finder_t): boolean;
    barcode_finder_found_number(o: zappar_barcode_finder_t): number;
    barcode_finder_found_text(o: zappar_barcode_finder_t, indx: number): string;
    barcode_finder_found_format(o: zappar_barcode_finder_t, indx: number): barcode_format_t;
    barcode_finder_formats(o: zappar_barcode_finder_t): barcode_format_t;
    barcode_finder_formats_set(o: zappar_barcode_finder_t, f: barcode_format_t): void;
    instant_world_tracker_create(pipeline: zappar_pipeline_t): zappar_instant_world_tracker_t;
    instant_world_tracker_destroy(o: zappar_instant_world_tracker_t): void;
    instant_world_tracker_enabled_set(o: zappar_instant_world_tracker_t, enabled: boolean): void;
    instant_world_tracker_enabled(o: zappar_instant_world_tracker_t): boolean;
    instant_world_tracker_anchor_pose_raw(o: zappar_instant_world_tracker_t): Float32Array;
    instant_world_tracker_anchor_pose_set_from_camera_offset_raw(o: zappar_instant_world_tracker_t, x: number, y: number, z: number, orientation: instant_world_tracker_transform_orientation_t): void;
    zapcode_tracker_create(pipeline: zappar_pipeline_t): zappar_zapcode_tracker_t;
    zapcode_tracker_destroy(o: zappar_zapcode_tracker_t): void;
    zapcode_tracker_target_load_from_memory(o: zappar_zapcode_tracker_t, data: ArrayBuffer): void;
    zapcode_tracker_target_loaded_version(o: zappar_zapcode_tracker_t): number;
    zapcode_tracker_enabled(o: zappar_zapcode_tracker_t): boolean;
    zapcode_tracker_enabled_set(o: zappar_zapcode_tracker_t, enabled: boolean): void;
    zapcode_tracker_anchor_count(o: zappar_zapcode_tracker_t): number;
    zapcode_tracker_anchor_id(o: zappar_zapcode_tracker_t, indx: number): string;
    zapcode_tracker_anchor_pose_raw(o: zappar_zapcode_tracker_t, indx: number): Float32Array;
    world_tracker_create(pipeline: zappar_pipeline_t): zappar_world_tracker_t;
    world_tracker_destroy(o: zappar_world_tracker_t): void;
    world_tracker_enabled(o: zappar_world_tracker_t): boolean;
    world_tracker_enabled_set(o: zappar_world_tracker_t, enabled: boolean): void;
    world_tracker_scale_mode(o: zappar_world_tracker_t): world_scale_mode_t;
    world_tracker_scale_mode_set(o: zappar_world_tracker_t, scale_mode: world_scale_mode_t): void;
    world_tracker_session_number(o: zappar_world_tracker_t): number;
    world_tracker_quality(o: zappar_world_tracker_t): number;
    world_tracker_horizontal_plane_detection_enabled(o: zappar_world_tracker_t): boolean;
    world_tracker_horizontal_plane_detection_enabled_set(o: zappar_world_tracker_t, horizontal_plane_detection_enabled: boolean): void;
    world_tracker_vertical_plane_detection_enabled(o: zappar_world_tracker_t): boolean;
    world_tracker_vertical_plane_detection_enabled_set(o: zappar_world_tracker_t, vertical_plane_detection_enabled: boolean): void;
    world_tracker_plane_anchor_count(o: zappar_world_tracker_t): number;
    world_tracker_plane_anchor_id(o: zappar_world_tracker_t, indx: number): string;
    world_tracker_plane_anchor_pose_raw(o: zappar_world_tracker_t, indx: number): Float32Array;
    world_tracker_plane_anchor_status(o: zappar_world_tracker_t, indx: number): anchor_status_t;
    world_tracker_plane_anchor_polygon_data_size(o: zappar_world_tracker_t, indx: number): number;
    world_tracker_plane_anchor_polygon_data(o: zappar_world_tracker_t, indx: number): Float32Array;
    world_tracker_plane_anchor_polygon_version(o: zappar_world_tracker_t, indx: number): number;
    world_tracker_plane_anchor_orientation(o: zappar_world_tracker_t, indx: number): plane_orientation_t;
    world_tracker_world_anchor_status(o: zappar_world_tracker_t): anchor_status_t;
    world_tracker_world_anchor_id(o: zappar_world_tracker_t): string;
    world_tracker_world_anchor_pose_raw(o: zappar_world_tracker_t): Float32Array;
    world_tracker_ground_anchor_id(o: zappar_world_tracker_t): string;
    world_tracker_ground_anchor_status(o: zappar_world_tracker_t): anchor_status_t;
    world_tracker_ground_anchor_pose_raw(o: zappar_world_tracker_t): Float32Array;
    world_tracker_reset(o: zappar_world_tracker_t): void;
    world_tracker_tracks_data_enabled(o: zappar_world_tracker_t): boolean;
    world_tracker_tracks_data_enabled_set(o: zappar_world_tracker_t, tracks_data_enabled: boolean): void;
    world_tracker_tracks_data_size(o: zappar_world_tracker_t): number;
    world_tracker_tracks_data(o: zappar_world_tracker_t): Float32Array;
    world_tracker_tracks_type_data_size(o: zappar_world_tracker_t): number;
    world_tracker_tracks_type_data(o: zappar_world_tracker_t): Uint8Array;
    world_tracker_projections_data_enabled(o: zappar_world_tracker_t): boolean;
    world_tracker_projections_data_enabled_set(o: zappar_world_tracker_t, projections_data_enabled: boolean): void;
    world_tracker_projections_data_size(o: zappar_world_tracker_t): number;
    world_tracker_projections_data(o: zappar_world_tracker_t): Float32Array;
    custom_anchor_create(pipeline: zappar_pipeline_t, worldtracker: zappar_world_tracker_t, id: string): zappar_custom_anchor_t;
    custom_anchor_destroy(o: zappar_custom_anchor_t): void;
    custom_anchor_status(o: zappar_custom_anchor_t): anchor_status_t;
    custom_anchor_pose_version(o: zappar_custom_anchor_t): number;
    custom_anchor_pose_raw(o: zappar_custom_anchor_t): Float32Array;
    custom_anchor_pose_set_from_camera_offset_raw(o: zappar_custom_anchor_t, x: number, y: number, z: number, orientation: transform_orientation_t): void;
    custom_anchor_pose_set_from_anchor_offset(o: zappar_custom_anchor_t, anchor_id: string, x: number, y: number, z: number, orientation: transform_orientation_t): void;
    custom_anchor_pose_set(o: zappar_custom_anchor_t, pose: Float32Array): void;
    custom_anchor_pose_set_with_parent(o: zappar_custom_anchor_t, pose: Float32Array, anchor_id: string): void;
    d3_tracker_create(pipeline: zappar_pipeline_t): zappar_d3_tracker_t;
    d3_tracker_destroy(o: zappar_d3_tracker_t): void;
}
