import { BridgedCameraSource } from "./bridged-camera-source";
import { CameraSource } from "./camera-source";
import { ImageBitmapCameraSource } from "./imagebitmap-camera-source";
import { zcout } from "./loglevel";
import { MSTPCameraSource } from "./mstp-camera-source";
import { profile } from "./profile";
import { WebXRCameraSource } from "./webxr-camera-source";
let latest = 1;
let byId = new Map();
export function getNextCameraSourceId() {
    return (latest++);
}
export function setCameraSourceId(id, c) {
    byId.set(id, c);
}
export function getCameraSource(id) {
    return byId.get(id);
}
export function deleteCameraSource(id) {
    byId.delete(id);
}
export function createCameraSource(p, deviceId, preferWebXrCamera) {
    let ret = getNextCameraSourceId();
    if (preferWebXrCamera && WebXRCameraSource.IsSupported() && deviceId === CameraSource.DEFAULT_DEVICE_ID)
        setCameraSourceId(ret, new WebXRCameraSource(ret, p));
    else if (BridgedCameraSource.IsSupported() && deviceId === CameraSource.DEFAULT_DEVICE_ID)
        setCameraSourceId(ret, new BridgedCameraSource(ret, p, deviceId));
    else if (profile.preferMediaStreamTrackProcessorCamera &&
        'MediaStreamTrackProcessor' in window &&
        'MediaStreamTrackGenerator' in window)
        setCameraSourceId(ret, new MSTPCameraSource(ret, p, deviceId));
    else if (profile.preferImageBitmapCamera && typeof OffscreenCanvas !== "undefined")
        setCameraSourceId(ret, new ImageBitmapCameraSource(ret, p, deviceId));
    else
        setCameraSourceId(ret, new CameraSource(ret, p, deviceId));
    zcout("camera_source_t initialized");
    return ret;
}
