const decoder = new TextDecoder();
const binaryReplyHeader = new Uint8Array([0x5A, 0x50, 0x52, 0x4D]); // "ZPRM"
const binaryReplyHeader_u16 = new Uint16Array(binaryReplyHeader.buffer);
export const BridgeArrayBufferHeader_u32 = (new Uint32Array(binaryReplyHeader.buffer))[0];
export function hasBridgeArrayBufferHeader(str) {
    if (str.length < 16)
        return false;
    if (str.charCodeAt(0) !== binaryReplyHeader_u16[0])
        return false;
    if (str.charCodeAt(1) !== binaryReplyHeader_u16[1])
        return false;
    return true;
}
// Temporary typed arrays to do reply ID extraction without generating any garbage
const binaryReplyMessageId = new Uint32Array(1);
const binaryReplyMessageId_u16 = new Uint16Array(binaryReplyMessageId.buffer);
export function replyIdFromBridgeArrayBuffer(str) {
    if (str.length < 16)
        return 0xFFFFFFFF;
    binaryReplyMessageId_u16[0] = str.charCodeAt(2);
    binaryReplyMessageId_u16[1] = str.charCodeAt(3);
    return binaryReplyMessageId[0];
}
export function parseBridgeArrayBuffer(ab) {
    if (ab.byteLength < 32)
        return;
    let offset = 0;
    const buffer32 = new Uint32Array(ab);
    if (buffer32[0] !== BridgeArrayBufferHeader_u32)
        return;
    offset += 4;
    const replyID = buffer32[offset >> 2];
    offset += 4;
    const jsonLength = buffer32[offset >> 2];
    offset += 4;
    const jsonData = new Uint8Array(ab, offset, jsonLength);
    const json = JSON.parse(decoder.decode(jsonData));
    offset += jsonLength;
    offset = ((offset + 15) >> 4) << 4; // Padding to 16 byte alignment
    const binaryBufferLength = buffer32[offset >> 2];
    offset += 4;
    offset += 12; // Padding
    return {
        replyID,
        json,
        uint8ArrayForBinaryBufferOffset: (o, length) => {
            return new Uint8Array(ab, offset + o, length);
        },
        floatArrayForBinaryBufferOffset: (o, length) => {
            return new Float32Array(ab, offset + o, length / 4);
        },
        uint32ArrayForBinaryBufferOffset: (o, length) => {
            return new Uint32Array(ab, offset + o, length / 4);
        }
    };
}
