import { camera_profile_t, zappar_camera_source_t, zappar_pipeline_t } from "./gen/zappar";
import { CameraFrameInfo, Source } from "./source";
import { zappar_custom_anchor_t } from "./gen/zappar-native";
export interface BridgeOptions {
    worldTracking?: boolean;
    horizontalPlaneDetection?: boolean;
    verticalPlaneDetection?: boolean;
    tracksData?: boolean;
    projectionsData?: boolean;
    meshAnchors?: boolean;
    d3?: boolean;
    d3MaxResolution?: boolean;
}
export declare class BridgedCameraSource extends Source {
    private _impl;
    private _pipeline;
    private _deviceId;
    static DEFAULT_DEVICE_ID: string;
    private _messageHandler;
    private _isPaused;
    private _cameraToScreenRotation;
    private _cameraToDeviceTransform;
    private _cameraModel;
    private _profile;
    private _textureSizes;
    private _yuvConversion;
    private _decodeBuffers;
    private _options;
    private static _resetCount;
    private _isAndroid;
    static IsSupported(): boolean;
    constructor(_impl: zappar_camera_source_t, _pipeline: zappar_pipeline_t, _deviceId: string);
    destroy(): void;
    pause(): void;
    start(): void;
    getFrame(currentlyProcessing: boolean): void;
    private _frameInFlight;
    private _processFrame;
    uploadGL(info: CameraFrameInfo): void;
    recycle(info: CameraFrameInfo): void;
    setProfile(p: camera_profile_t): void;
    private _anchorPoseFloat32;
    private _anchorPoseUint16;
    setCustomAnchorPose(anchor: zappar_custom_anchor_t, pose_version: number, pose: Float32Array): void;
    resetTracking(): void;
    private _convertToBitmask;
    optionsUpdated(options: BridgeOptions): void;
    private _lastTimestamp;
    private _deviceMotionListener;
    private _deviceOrientationListener;
    private _startDeviceMotion;
    private _stopDeviceMotion;
}
