import { CollisionEventType, Component, Object3D, PhysXComponent, WonderlandEngine } from '@wonderlandengine/api';
import { Grabbable } from './grabbable.js';
import { InteractorVisualState } from './grab-point.js';
import { InteractorInput } from './interactor-input.js';
/**
 * Manages interaction capabilities of a VR controller or a similar input device.
 *
 * The `Interactor` class enables an entity to grip or interact with objects that
 * implement the {@link Interactable} interface.
 */
export declare class Interactor extends Component {
    #private;
    static TypeName: string;
    static onRegister(engine: WonderlandEngine): void;
    /** Properties */
    inputObject: Object3D;
    meshRoot: Object3D | null;
    visualStateOnGrab: InteractorVisualState;
    trackedSpace: Object3D;
    /** Private Attributes. */
    private _input;
    /** Collision component of this object. */
    private _collision;
    /** Physx component of this object. */
    private _physx;
    /**
     * Physx collision callback index.
     *
     * @hidden
     */
    private _physxCallback;
    /** Cached interactable after it's gripped. */
    private _grabbable;
    private _onGrabStart;
    private _onGrabEnd;
    /**
     * Set the collision component needed to perform
     * grab interaction
     *
     * @param collision The collision component
     *
     * @returns This instance, for chaining
     */
    start(): void;
    onActivate(): void;
    onDeactivate(): void;
    /**
     * Force this interactor to start interacting with the given interactable.
     *
     * @param interactable The interactable to process.
     */
    startInteraction(interactable: Grabbable, handleId: number): void;
    /**
     * Check for nearby interactable, and notifies one if this interactor
     * interacts with it.
     */
    checkForNearbyInteractables(): void;
    onPhysxCollision: (type: CollisionEventType, other: PhysXComponent) => void;
    /**
     * Force this interactor to stop interacting with the
     * currently bound interactable.
     */
    stopInteraction(): void;
    /**
     * Current interactable handled by this interactor. If no interaction is ongoing,
     * this getter returns `null`.
     */
    get interactable(): Grabbable | null;
    /** {@link InteractorInput} */
    get input(): InteractorInput;
}
