var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, Emitter, InputComponent, property, } from '@wonderlandengine/api';
import { componentError, enumStringKeys } from '../utils/wle.js';
/**
 * Typename for a `PlayerControllerInput` component.
 *
 * Use this to create your own input component that can
 * be retrieved by {@link PlayerController}:
 *
 * ```ts
 * import {PlayerControllerInput, PlayerControllerInputTypename} fromn '@wonderlandengine/interaction';
 *
 * export class CustomPlayerInput implements PlayerControllerInput {
 *     static TypeName = PlayerControllerInputTypename;
 *     ...
 * }
 * ```
 */
export const InteractorInputTypename = 'interactor-input';
/** Semantic mapping for XR controller button. */
export var XRButton;
(function (XRButton) {
    XRButton[XRButton["Trigger"] = 0] = "Trigger";
    XRButton[XRButton["Grip"] = 1] = "Grip";
    XRButton[XRButton["Joystick"] = 2] = "Joystick";
    XRButton[XRButton["PrimaryButton"] = 3] = "PrimaryButton";
    XRButton[XRButton["SecondaryButton"] = 4] = "SecondaryButton";
})(XRButton || (XRButton = {}));
/** List of string keys for {@link XRButton}. */
export const XRButtonNames = enumStringKeys(XRButton);
/**
 * Binding for XR buttons.
 *
 * This is a direct mapping to `buttons`:
 * https://developer.mozilla.org/en-US/docs/Web/API/Gamepad/buttons
 */
var XRBinding;
(function (XRBinding) {
    XRBinding[XRBinding["Trigger"] = 0] = "Trigger";
    XRBinding[XRBinding["Grip"] = 1] = "Grip";
    XRBinding[XRBinding["Joystick"] = 2] = "Joystick";
    XRBinding[XRBinding["PrimaryButton"] = 4] = "PrimaryButton";
    XRBinding[XRBinding["SecondaryButton"] = 5] = "SecondaryButton";
})(XRBinding || (XRBinding = {}));
const Mapping = XRButtonNames.map((n) => XRBinding[n]);
/**
 * Default inputs for {@link Interactor}.
 *
 * Currently supports:
 * - VR controllers
 *
 * For fully custom inputs, derive {@link InteractorInput} instead.
 */
export class DefaultInteractorInput extends Component {
    static TypeName = InteractorInputTypename;
    /* VR gamepads */
    /** Object with a native input component.*/
    inputObject;
    grab = XRButton.Grip;
    /* Public attributes */
    onGrabStart = new Emitter();
    onGrabEnd = new Emitter();
    /* Private attributes */
    _input;
    _grabPressed = false;
    _xrPose = null;
    /** @hidden */
    _onPreRender = () => {
        this._xrPose = null;
        const source = this._input.xrInputSource;
        if (!source || !source.gripSpace)
            return;
        const xr = this.engine.xr;
        const referenceSpace = xr.referenceSpaceForType('local-floor') ?? xr.referenceSpaceForType('local');
        if (!referenceSpace)
            return;
        const pose = xr.frame.getPose(source.gripSpace, referenceSpace);
        this._xrPose = pose ?? null;
    };
    getInputSourceXR() {
        return this._input.xrInputSource;
    }
    /** @override */
    onActivate() {
        const input = this.inputObject.getComponent(InputComponent);
        if (!input) {
            throw new Error(componentError(this, 'inputObject does not have a InputComponent'));
        }
        this._input = input;
        const scene = this.scene;
        scene.onPreRender.add(this._onPreRender);
    }
    onDeactivate() {
        const scene = this.scene;
        scene.onPreRender.remove(this._onPreRender);
    }
    /** @override */
    update() {
        const previous = this._grabPressed;
        const gamepad = this._input.xrInputSource?.gamepad;
        if (gamepad) {
            const remapped = Mapping[this.grab];
            const button = gamepad.buttons[remapped];
            this._grabPressed = button?.pressed ?? false;
        }
        if (!previous && this._grabPressed) {
            this.onGrabStart.notify();
        }
        else if (previous && !this._grabPressed) {
            this.onGrabEnd.notify();
        }
    }
    get xrPose() {
        return this._xrPose;
    }
}
__decorate([
    property.object({ required: true })
], DefaultInteractorInput.prototype, "inputObject", void 0);
__decorate([
    property.enum(XRButtonNames, XRButton.Grip)
], DefaultInteractorInput.prototype, "grab", void 0);
