/**
 * Inverse kinematics for two-joint chains (e.g. knees or elbows)
 */
export class TwoJointIkSolver extends Component {
    static Properties: {
        /** Root bone, never moves */
        root: import("@wonderlandengine/api").ComponentProperty;
        /** Bone attached to the root */
        middle: import("@wonderlandengine/api").ComponentProperty;
        /** Bone attached to the middle */
        end: import("@wonderlandengine/api").ComponentProperty;
        /** Target the joins should reach for */
        target: import("@wonderlandengine/api").ComponentProperty;
        /** Flag for copying rotation from target to end */
        copyTargetRotation: import("@wonderlandengine/api").ComponentProperty;
        /** Helper object to use to determine joint rotation axis */
        helper: import("@wonderlandengine/api").ComponentProperty;
    };
    time: number;
    middlePos: Float32Array;
    endPos: Float32Array;
    targetPos: Float32Array;
    helperPos: Float32Array;
    rootTransform: Float32Array;
    middleTransform: Float32Array;
    endTransform: Float32Array;
    start(): void;
    update(dt: any): void;
}
import { Component } from '@wonderlandengine/api';
