import { Component, Object3D } from '@wonderlandengine/api';
/**
 * Provider-agnostic hit-test reticle for SLAM-based AR.
 *
 * Works with any tracking provider that implements
 * {@link ITrackingMode.setupHitTest} / {@link ITrackingMode.getHitTestResult}:
 *
 * - **WebXR Device API** — uses `XRHitTestSource` (requires `hit-test` in
 *   optional features).
 * - **8th Wall** — ray–ground-plane intersection (no extra setup needed).
 * - **Zappar** — ray–plane intersection against `WorldTracker` detected planes
 *   (requires `@zappar/zappar >= 4.x`).
 *
 * **Setup**
 * 1. Attach this component to a reticle / cursor object that optionally has a
 *    {@link MeshComponent} for visual feedback.
 * 2. Set the `camera` property to the scene object carrying {@link ARSLAMCamera}.
 * 3. Use {@link SpawnMeshOnReticle} (or equivalent) on the same object to
 *    place content at the hit position on tap/select.
 *
 * Replaces the provider-specific `hit-test-location-root`,
 * `hit-test-location-xr8`, and `hit-test-location-zappar` components.
 */
export declare class HitTestLocation extends Component {
    static TypeName: string;
    /** Scene object that carries the {@link ARSLAMCamera} component. */
    camera: Object3D;
    private _slamCamera;
    private _mesh;
    private readonly _posBuffer;
    start(): void;
    update(): void;
    private _onSessionStart;
    private _onSessionEnd;
}
