import { ImageTrackingMode } from '../tracking-mode.js';
import { TrackingType } from '../tracking-type.js';
import { ARTrackingCameraBase } from './AR-tracking-camera-base.js';
/**
 * AR image tracking Camera component.
 *
 * Should be attached the object which has a ViewComponent.
 *
 * Currently only works with 8th Wall tracking `WorldTracking_XR8`
 */
export declare class ARImageTrackingCamera extends ARTrackingCameraBase<ImageTrackingMode> {
    static TypeName: string;
    static InheritProperties: boolean;
    protected getTrackingType(): TrackingType;
    enableSLAM: number;
    get onImageScanning(): import("@wonderlandengine/api/decorators.js").Emitter<[event: import("../tracking-mode.js").ImageScanningEvent]>;
    get onImageFound(): import("@wonderlandengine/api/decorators.js").Emitter<[event: import("../tracking-mode.js").ImageTrackedEvent]>;
    get onImageUpdate(): import("@wonderlandengine/api/decorators.js").Emitter<[event: import("../tracking-mode.js").ImageTrackedEvent]>;
    get onImageLost(): import("@wonderlandengine/api/decorators.js").Emitter<[event: import("../tracking-mode.js").ImageTrackedEvent]>;
    /**
     * Pre-registers an image tracking target with the active provider.
     *
     * Delegates to {@link ImageTrackingMode.registerTarget} if the provider
     * implements it (e.g. Zappar requires `.zpt` files to be loaded before
     * tracking starts). Providers that do not need pre-registration will
     * silently ignore this call.
     *
     * Call from a response component's `start()` hook, passing the same
     * `name` that the component uses as its `imageId`.
     *
     * @param source URL or `ArrayBuffer` of the target file.
     * @param options.name Must match the `imageId` on tracker components.
     * @param options.physicalWidthInMeters Optional physical width in metres.
     */
    registerTarget(source: string | ArrayBuffer, options: {
        name: string;
        physicalWidthInMeters?: number;
    }): Promise<void>;
}
