import { FaceTrackingMode } from '../tracking-mode.js';
import { TrackingType } from '../tracking-type.js';
import { ARTrackingCameraBase } from './AR-tracking-camera-base.js';
/**
 * AR face tracking Camera component.
 *
 * Should be attached the object which has a ViewComponent.
 *
 * Currently only works with 8th Wall tracking `FaceTracking_XR8`
 */
export declare class ARFaceTrackingCamera extends ARTrackingCameraBase<FaceTrackingMode> {
    static TypeName: string;
    static InheritProperties: boolean;
    protected getTrackingType(): TrackingType;
    cameraDirection: number;
    get onFaceLoading(): import("@wonderlandengine/api/decorators.js").Emitter<[event: import("../tracking-mode.js").FaceLoadingEvent]>;
    get onFaceFound(): import("@wonderlandengine/api/decorators.js").Emitter<[event: import("../tracking-mode.js").FaceFoundEvent]>;
    get onFaceUpdate(): import("@wonderlandengine/api/decorators.js").Emitter<[event: import("../tracking-mode.js").FaceFoundEvent]>;
    get onFaceLost(): import("@wonderlandengine/api/decorators.js").Emitter<[event: import("../tracking-mode.js").FaceLostEvent]>;
    protected validateStart(): void;
}
