import { VPSTrackingMode } from '../tracking-mode.js';
import { TrackingType } from '../tracking-type.js';
import { ARTrackingCameraBase } from './AR-tracking-camera-base.js';
/**
 * AR VPS tracking Camera component.
 *
 * Should be attached the object which has a ViewComponent.
 *
 * Currently only works with 8th Wall tracking `WorldTracking_XR8`.
 *
 * Check 8th Wall Lightship VPS system for details. (https://www.8thwall.com/docs/web/#lightship-vps)
 *
 * IMPORTANT: for this camera to run correctly,
 * clear the "Project Settings/Editor/serverCOEP" field.
 * Warning - it will disable the WASM thread support.
 */
export declare class ARVPSCamera extends ARTrackingCameraBase<VPSTrackingMode> {
    static TypeName: string;
    protected getTrackingType(): TrackingType;
    /**
     * make sure noone can overwrite this
     */
    get usesVPS(): boolean;
    get onWaySpotFound(): import("@wonderlandengine/api").Emitter<[event: import("../tracking-mode.js").VPSWayPointEvent]>;
    get onWaySpotUpdated(): import("@wonderlandengine/api").Emitter<[event: import("../tracking-mode.js").VPSWayPointEvent]>;
    get onWaySpotLost(): import("@wonderlandengine/api").Emitter<[event: import("../tracking-mode.js").VPSWayPointEvent]>;
    get onMeshFound(): import("@wonderlandengine/api").Emitter<[event: import("../tracking-mode.js").VPSMeshFoundEvent]>;
    protected getTrackingInitFeatures(): string[];
}
