function ensureEditorWindow() {
    if (typeof window !== 'undefined')
        return;
    if (typeof WL_EDITOR === 'undefined' || !WL_EDITOR)
        return;
    const globalObject = globalThis;
    if (!globalObject.window) {
        globalObject.window = globalObject;
    }
    const ensuredWindow = globalObject.window;
    if (!ensuredWindow.location) {
        ensuredWindow.location = { href: '' };
    }
}
let zapparPromise = null;
let zapparCorePromise = null;
export function loadZappar() {
    if (!zapparPromise) {
        zapparPromise = (async () => {
            ensureEditorWindow();
            return import('@zappar/zappar');
        })();
    }
    return zapparPromise;
}
async function loadZapparCore() {
    if (!zapparCorePromise) {
        zapparCorePromise = (async () => {
            ensureEditorWindow();
            return import('@zappar/zappar/lib/zappar.js');
        })();
    }
    return zapparCorePromise;
}
export async function setOptions(opts) {
    const [core, main] = await Promise.all([loadZapparCore(), loadZappar()]);
    core.setOptions(opts);
    /* If the main module also has setOptions (it might be re-exported), call it too.
     * This helps if the bundler has duplicated the zappar module instance. */
    if (main.setOptions && main.setOptions !== core.setOptions) {
        main.setOptions(opts);
    }
}
