/// <reference path="../../src/types/global.d.ts" />
import { Component } from '@wonderlandengine/api';
import { HitTestResult, TrackingMode } from '@wonderlandengine/ar-tracking';
import { ZapparProvider } from './zappar-provider.js';
/**
 * SLAM tracking implementation backed by Zappar.
 */
export declare class WorldTracking_Zappar extends TrackingMode {
    private readonly _cameraTransform;
    constructor(provider: ZapparProvider, component: Component);
    init(): void;
    startSession(): void;
    endSession(): void;
    getCameraTransformWorld(): ArrayLike<number> | null;
    getCameraProjectionMatrix(out: Float32Array): boolean;
    update(): void;
    setupHitTest(): Promise<void>;
    /**
     * Cast a ray from the camera through the screen centre and return the closest
     * intersection with any of the Zappar-detected plane anchors.
     */
    getHitTestResult(): HitTestResult | null;
}
