import { Emitter } from '@wonderlandengine/api';
import { ImageScanningEvent, ImageTrackedEvent, ImageTrackingMode, TrackingMode } from '@wonderlandengine/ar-tracking';
export declare class ImageTracking_Zappar extends TrackingMode implements ImageTrackingMode {
    private _zappar;
    private _view?;
    private _imageTracker?;
    private _resourcesReady;
    private _resourcesPromise;
    private _targetsSubscriptionAdded;
    private readonly _cameraMatrix;
    private readonly _cameraPosition;
    private readonly _cameraRotation;
    private readonly _cameraScale;
    private readonly _scratchMatrix;
    private readonly _scratchPosition;
    private readonly _scratchRotation;
    private readonly _scratchScale;
    private readonly _lastAnchorEvents;
    readonly onImageScanning: Emitter<[event: ImageScanningEvent]>;
    readonly onImageFound: Emitter<[event: ImageTrackedEvent]>;
    readonly onImageUpdate: Emitter<[event: ImageTrackedEvent]>;
    readonly onImageLost: Emitter<[event: ImageTrackedEvent]>;
    registerTarget(source: string | ArrayBuffer, options: {
        name: string;
        physicalWidthInMeters?: number;
    }): Promise<void>;
    init(): void;
    startSession(): void;
    endSession(): void;
    update(): void;
    private _prepareResources;
    private _handleTargetsChanged;
    private _emitScanningEvent;
    private _handleAnchorVisible;
    private _handleAnchorNotVisible;
    private _buildImageEvent;
    private _guessDescriptor;
    private _applyCameraPose;
    private _setProjectionMatrixWithEngineRemap;
}
