import { TrackingMode, HitTestResult } from '@wonderlandengine/ar-tracking';
import { WebXRConfig, WebXRProvider } from './webxr-provider.js';
import { Component } from '@wonderlandengine/api';
/**
 * Implementation of SLAM (World Tracking) based on the WebXR Device API
 *
 * Depends on WEBXR_REQUIRED_FEATURES, WEBXR_OPTIONAL_FEATURES global variables.
 *
 * TODO: change this when it's moved to auto constants.
 */
export declare class WorldTracking_WebXR extends TrackingMode {
    private _config;
    private _hitTestSource;
    constructor(provider: WebXRProvider, component: Component, config: WebXRConfig);
    startSession(): void;
    endSession(): void;
    setupHitTest(): Promise<void>;
    teardownHitTest(): void;
    getHitTestResult(): HitTestResult | null;
}
