/// <reference types="webxr" />
import { Component } from '@wonderlandengine/api';
import { ARProvider, ARSession, ITrackingMode, TrackingType } from '@wonderlandengine/ar-tracking';
export interface WebXRConfig {
    requiredFeatures: string[];
    optionalFeatures: string[];
}
/**
 * ARProvider implementation for device native WebXR API
 */
export declare class WebXRProvider extends ARProvider {
    private _xrSession;
    get xrSession(): XRSession | null;
    static Name: string;
    get name(): string;
    private _config;
    static registerTrackingProviderWithARSession(arSession: ARSession, config: WebXRConfig): WebXRProvider;
    private constructor();
    startSession(webxrRequiredFeatures?: string[], webxrOptionalFeatures?: string[]): Promise<void>;
    endSession(): Promise<void>;
    load(): Promise<void>;
    /** Whether this provider supports given tracking type */
    supports(type: TrackingType): boolean;
    /** Create a tracking implementation */
    createTracking(type: TrackingType, component: Component): ITrackingMode;
}
