import { quat2, vec3 } from 'gl-matrix';
/**
 * Convert degrees to radians.
 *
 * @param degrees Value, in **degrees**.
 */
export declare function toRad(degrees: number): number;
/**
 * Convert radians to degrees.
 *
 * @param degrees Value, in **radians**.
 */
export declare function toDegree(radians: number): number;
/**
 * Check whether two points are **almost** equal.
 *
 * @param a Source point.
 * @param b Target point.
 * @param epsilon Epsilon threshold.
 * @returns `true` if almost equal, `false` otherwise.
 */
export declare function isPointEqual(a: vec3, b: vec3, epsilon: number): boolean;
/**
 * Compute the relative transformation from source to target.
 *
 * @note
 * - The result transform is expressed in the target's space.
 * - In order to get the world transform of `source`, the target's world
 *   transform will need to be multiplied by the result of this function.
 *
 * @param out The destination.
 * @param source The source object.
 * @param target The target object.
 * @returns The `out` parameter.
 */
export declare const computeRelativeTransform: (out: quat2, source: quat2, target: quat2) => quat2;
