/** Statically sized temporary stack. */
class StaticStack {
    _data;
    _views;
    _sentinel = 0;
    constructor(componentCount, maxCount = 8) {
        this._data = new Float32Array(maxCount * componentCount);
        this._views = new Array(maxCount);
        const bytesPerElement = componentCount * Float32Array.BYTES_PER_ELEMENT;
        for (let i = 0; i < maxCount; ++i) {
            this._views[i] = new Float32Array(this._data.buffer, i * bytesPerElement, componentCount);
        }
    }
    /** Acquire a element */
    get() {
        return this._views[this._sentinel++];
    }
    /** Release `count` elements */
    free(count = 1) {
        this._sentinel -= count;
    }
}
/**
 * Stack of vector 3 temporaries.
 *
 * @hidden
 */
export const TempVec3 = new StaticStack(3, 16);
/**
 * Stack of quaternion temporaries.
 *
 * @hidden
 */
export const TempQuat = new StaticStack(4);
/**
 * Stack of quaternion temporaries.
 *
 * @hidden
 */
export const TempDualQuat = new StaticStack(8);
/**
 * Stack of 4x4 matrix temporaries.
 *
 * @hidden
 */
export const TempMat4 = new StaticStack(16);
