import { mat4, quat, quat2, vec3 } from 'gl-matrix';
/** Statically sized temporary stack. */
declare class StaticStack<T> {
    private _data;
    private _views;
    private _sentinel;
    constructor(componentCount: number, maxCount?: number);
    /** Acquire a element */
    get(): T;
    /** Release `count` elements */
    free(count?: number): void;
}
/**
 * Stack of vector 3 temporaries.
 *
 * @hidden
 */
export declare const TempVec3: StaticStack<vec3>;
/**
 * Stack of quaternion temporaries.
 *
 * @hidden
 */
export declare const TempQuat: StaticStack<quat>;
/**
 * Stack of quaternion temporaries.
 *
 * @hidden
 */
export declare const TempDualQuat: StaticStack<quat2>;
/**
 * Stack of 4x4 matrix temporaries.
 *
 * @hidden
 */
export declare const TempMat4: StaticStack<mat4>;
export {};
