var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, property } from '@wonderlandengine/api';
import { enumStringKeys } from '../utils/wle.js';
/**
 * Visual state to apply to an interactor.
 */
export var InteractorVisualState;
(function (InteractorVisualState) {
    /** Unspecified. */
    InteractorVisualState[InteractorVisualState["None"] = 0] = "None";
    /** Interactor mesh should be set to visible. */
    InteractorVisualState[InteractorVisualState["Visible"] = 1] = "Visible";
    /** Interactor mesh should be hidden. */
    InteractorVisualState[InteractorVisualState["Hidden"] = 2] = "Hidden";
})(InteractorVisualState || (InteractorVisualState = {}));
/** List of string keys for {@link InteractorVisualState}. */
export const InteractorVisualStateNames = enumStringKeys(InteractorVisualState);
/**
 * Describe how the {@link Interactor} interacts with a {@link GrabPoint}.
 */
export var GrabSearchMode;
(function (GrabSearchMode) {
    /**
     * Interaction occurs if the distance with the grab point
     * is in range of {@link GrabPoint.maxDistance}.
     */
    GrabSearchMode[GrabSearchMode["Distance"] = 0] = "Distance";
    /**
     * Interaction occurs if the grab point collision or physx collider
     * overlaps with the interactor.
     */
    GrabSearchMode[GrabSearchMode["Overlap"] = 1] = "Overlap";
})(GrabSearchMode || (GrabSearchMode = {}));
/** List of string keys for {@link GrabSearchMode}. */
export const GrabSearchModeNames = enumStringKeys(GrabSearchMode);
/**
 * Describe how the {@link Grabbable} behave once the interaction starts
 * with the {@link GrabPoint}.
 */
export var GrabSnapMode;
(function (GrabSnapMode) {
    /**
     * Grabbable is grabbed at the point of interaction,
     * doesn't snap to the grab point.
     */
    GrabSnapMode[GrabSnapMode["None"] = 0] = "None";
    /**
     * Grabbable is snapped to the interactor, using the grab point
     * as position / rotation for anchoring.
     */
    GrabSnapMode[GrabSnapMode["PositionRotation"] = 1] = "PositionRotation";
})(GrabSnapMode || (GrabSnapMode = {}));
/** List of string keys for {@link GrabSnapMode}. */
export const GrabSnapModeNames = enumStringKeys(GrabSnapMode);
/**
 * Link used to specify how / where a {@link Grabbable} is grabbed.
 */
export class GrabPoint extends Component {
    static TypeName = 'grab-point';
    /** Snap mode, defaults to {@link GrabSnapMode.PositionRotation} */
    snap = GrabSnapMode.PositionRotation;
    /**
     * Lerp value used during interaction.
     *
     * Smaller values make the grabbable more slowly snap to the interactor,
     * higher values make the snapping effect more instantaneous.
     *
     * @note This value is clamped in the range `[0, 1]`.
     *
     * Defaults to `0.75`.
     */
    snapLerp = 0.75;
    /** Search mode, defaults to {@link GrabSearchMode.Distance} */
    searchMode = GrabSearchMode.Distance;
    /**
     * Maximum distance at which interaction can occur.
     *
     * @note This is only used if {@link searchMode} is set to {@link GrabSearchMode.Distance}.
     */
    maxDistance = 0.2;
    /** If `true`, handle can be transfered to another interactor. */
    transferable = false;
    /** Visual state to apply to the interactor once interaction occurs. */
    interactorVisualState = InteractorVisualState.None;
    /** @hidden */
    _interactor = null;
    /** Current interactor managing this instance. */
    get interactor() {
        return this._interactor;
    }
}
__decorate([
    property.enum(GrabSnapModeNames, GrabSnapMode.PositionRotation)
], GrabPoint.prototype, "snap", void 0);
__decorate([
    property.float(0.75)
], GrabPoint.prototype, "snapLerp", void 0);
__decorate([
    property.enum(GrabSearchModeNames, GrabSearchMode.Distance)
], GrabPoint.prototype, "searchMode", void 0);
__decorate([
    property.float(0.2)
], GrabPoint.prototype, "maxDistance", void 0);
__decorate([
    property.bool(false)
], GrabPoint.prototype, "transferable", void 0);
__decorate([
    property.enum(InteractorVisualStateNames, InteractorVisualState.None)
], GrabPoint.prototype, "interactorVisualState", void 0);
