import { Component } from '@wonderlandengine/api';
/**
 * Translation constraint components for **local** position.
 */
export declare class TranslationConstraint extends Component {
    static TypeName: string;
    /**
     * Minimum allowed position, in **local space**.
     *
     * @note To disable constraint on an axis, use a value larger
     * than {@link max}. e.g.,
     *
     * ```ts
     * // Disable constraint for the x axis
     * constraint.min[0] = 1;
     * constraint.max[0] = -1;
     * ```
     */
    min: Float32Array;
    /**
     * Maximum allowed position, in **local space**.
     *
     * @note To disable constraint on an axis, use a value smaller
     * than {@link min}. e.g.,
     *
     * ```ts
     * // Disable constraint for the x axis
     * constraint.min[0] = 1;
     * constraint.max[0] = -1;
     * ```
     */
    max: Float32Array;
    /** @override */
    update(): void;
}
/**
 * Rotation constraint components for **local** position.
 *
 * @note This component currently decomposes the rotation into euler angles,
 * which might create glimbal lock. In addition, the yaw/pitch/roll order is
 * currently not exposed.
 */
export declare class RotationConstraint extends Component {
    static TypeName: string;
    lockX: boolean;
    lockY: boolean;
    lockZ: boolean;
    /**
     * Minimum allowed rotation, in **degrees**, in **local space**.
     *
     * @note To disable constraint on an axis, use a value larger
     * than {@link max}. e.g.,
     *
     * ```ts
     * // Disable constraint for the x axis
     * constraint.min[0] = 1;
     * constraint.max[0] = -1;
     * ```
     */
    min: Float32Array;
    /**
     * Maximum allowed rotation, in **degrees**, in **local space**.
     *
     * @note To disable constraint on an axis, use a value larger
     * than {@link max}. e.g.,
     *
     * ```ts
     * // Disable constraint for the x axis
     * constraint.min[0] = 1;
     * constraint.max[0] = -1;
     * ```
     */
    max: Float32Array;
    private _locked;
    /** @override */
    onActivate(): void;
    /** @override */
    update(): void;
}
