import { Material, Texture } from '@wonderlandengine/api';
/**
 * Set the diffuse/flat texture of known pipelines.
 *
 * @param mat Material to set the texture on
 * @param texture Texture to set
 * @param customTextureProperty Texture property to set or `'auto'` to automatically
 *      detect the right texture property based on known pipeline.
 * @returns `true` if the property was set, `false` otherwise.
 */
export declare function setFirstMaterialTexture(mat: Material, texture: Texture, customTextureProperty: string): boolean;
export declare function deg2rad(value: number): number;
export declare function rad2deg(value: number): number;
