import { WonderlandEngine } from '../engine.js';
import { ProbeVolumeScenario } from '../wonderland.js';
import { ResourceManager } from './resource.js';
/**
 * Manage probe volume scenarios.
 *
 * #### Creation
 *
 * Scenarios must be loaded using:
 *
 * ```js
 * const scenario = await engine.probeVolumeScenarios.load('scenario.data.bin');
 * ```
 *
 * Scenario files are generated by the Wonderland Editor.
 *
 * @since 1.5.0
 */
export declare class ProbeVolumeScenarioManager extends ResourceManager<ProbeVolumeScenario> {
    constructor(engine: WonderlandEngine);
    /**
     * Load the probe volume scenario
     *
     * @note The scenario is loaded but not applied. To select it,
     * use {@link Scene.probeVolumeScenario}.
     *
     * @param filename Relative URL from the main scene `.bin` file to the scenario,
     *     e.g., 'scenarios/day.data.bin'.
     */
    load(filename: string): Promise<ProbeVolumeScenario>;
    /**
     * Retrieve a scenario by filename.
     *
     * @param filename The string containing the filename.
     * @returns The scenario if found, `null` otherwise.
     */
    find(filename: string): ProbeVolumeScenario | null;
}
