var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@wonderlandengine/api';
import { setFirstMaterialTexture } from './utils/utils.js';
import { property } from '@wonderlandengine/api/decorators.js';
/**
 * Downloads an image from URL and applies it as `diffuseTexture` or `flatTexture`
 * to an attached mesh component.
 *
 * Materials from the following shaders are supported:
 *  - "Phong Opaque Textured"
 *  - "Flat Opaque Textured"
 *  - "Background"
 *  - "Physical Opaque Textured"
 *  - "Foliage"
 */
class ImageTexture extends Component {
    static TypeName = 'image-texture';
    /** URL to download the image from */
    url;
    /** Material to apply the video texture to */
    material;
    /** Name of the texture property to set */
    textureProperty;
    texture;
    start() {
        this.engine.textures
            .load(this.url, 'anonymous')
            .then((texture) => {
            this.texture = texture;
            const mat = this.material;
            if (!setFirstMaterialTexture(mat, texture, this.textureProperty)) {
                console.error('Pipeline', mat.pipeline, 'not supported by image-texture');
            }
        })
            .catch(console.error);
    }
    onDestroy() {
        this.texture?.destroy();
    }
}
__decorate([
    property.string()
], ImageTexture.prototype, "url", void 0);
__decorate([
    property.material({ required: true })
], ImageTexture.prototype, "material", void 0);
__decorate([
    property.string('auto')
], ImageTexture.prototype, "textureProperty", void 0);
export { ImageTexture };
//# sourceMappingURL=image-texture.js.map