var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@wonderlandengine/api';
import { property } from '@wonderlandengine/api/decorators.js';
/**
 * Applies [fixed foveation](https://www.w3.org/TR/webxrlayers-1/#dom-xrcompositionlayer-fixedfoveation)
 * once a WebXR session is started
 *
 * Fixed foveation reduces shading cost at the periphery by rendering at lower resolutions at the
 * edges of the users vision.
 */
class FixedFoveation extends Component {
    static TypeName = 'fixed-foveation';
    /** Amount to apply from 0 (none) to 1 (full) */
    fixedFoveation;
    onActivate() {
        this.engine.onXRSessionStart.add(this.setFixedFoveation);
    }
    onDeactivate() {
        this.engine.onXRSessionStart.remove(this.setFixedFoveation);
    }
    setFixedFoveation = () => {
        this.engine.xr.baseLayer.fixedFoveation = this.fixedFoveation;
    };
}
__decorate([
    property.float(0.5)
], FixedFoveation.prototype, "fixedFoveation", void 0);
export { FixedFoveation };
//# sourceMappingURL=fixed-foveation.js.map