/**
 * Teleport VR locomotion.
 *
 * See [Teleport Example](/showcase/teleport).
 */
export class TeleportComponent extends Component {
    static Properties: {
        /** Object that will be placed as indiciation forwhere the player will teleport to. */
        teleportIndicatorMeshObject: {
            type: Type;
        };
        /** Root of the player, the object that will be positioned on teleportation. */
        camRoot: {
            type: Type;
        };
        /** Non-vr camera for use outside of VR */
        cam: {
            type: Type;
        };
        /** Left eye for use in VR*/
        eyeLeft: {
            type: Type;
        };
        /** Right eye for use in VR*/
        eyeRight: {
            type: Type;
        };
        /** Handedness for VR cursors to accept trigger events only from respective controller. */
        handedness: {
            type: Type;
            values: string[];
            default: string;
        };
        /** Collision group of valid "floor" objects that can be teleported on */
        floorGroup: {
            type: Type;
            default: number;
        };
        /** How far the thumbstick needs to be pushed to have the teleport target indicator show up */
        thumbstickActivationThreshhold: {
            type: Type;
            default: number;
        };
        /** How far the thumbstick needs to be released to execute the teleport */
        thumbstickDeactivationThreshhold: {
            type: Type;
            default: number;
        };
        /** Offset to apply to the indicator object, e.g. to avoid it from Z-fighting with the floor */
        indicatorYOffset: {
            type: Type;
            default: number;
        };
        /** Mode for raycasting, whether to use PhysX or simple collision components */
        rayCastMode: {
            type: Type;
            values: string[];
            default: string;
        };
        /** Max distance for PhysX raycast */
        maxDistance: {
            type: Type;
            default: number;
        };
    };
    init(): void;
    _prevThumbstickAxis: Float32Array | undefined;
    _tempVec: Float32Array | undefined;
    _tempVec0: Float32Array | undefined;
    _currentIndicatorRotation: number | undefined;
    input: import("@wonderlandengine/api").InputComponent | null | undefined;
    isIndicating: boolean | undefined;
    indicatorHidden: boolean | undefined;
    hitSpot: Float32Array | undefined;
    _hasHit: boolean | undefined;
    _extraRotation: number | undefined;
    _currentStickAxes: Float32Array | undefined;
    start(): void;
    handedness: any;
    onSessionStartCallback: ((s: any) => void) | undefined;
    onActivate(): void;
    isMouseIndicating: boolean | undefined;
    onDeactivate(): void;
    _getCamRotation(): number;
    update(): void;
    rayHit: import("@wonderlandengine/api").RayHit | undefined;
    setupVREvents(s: any): void;
    session: any;
    gamepad: any;
    onMouseDown: () => void;
    onMouseUp: () => void;
    onMousePressed(): void;
    _teleportPlayer(newPosition: any, rotationToAdd: any): void;
}
import { Component } from '@wonderlandengine/api';
import { Type } from '@wonderlandengine/api';
