var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@wonderlandengine/api';
import { property } from '@wonderlandengine/api/decorators.js';
/**
 * Sets the target framerate
 *
 * [Updates the target framerate](https://immersive-web.github.io/webxr/#dom-xrsession-updatetargetframerate)
 * to the closest [supported target framerate](https://immersive-web.github.io/webxr/#dom-xrsession-supportedFrameRates)
 * to the given `framerate`.
 *
 * The target framerate is used for the device's VR compositor as an indication of how often to refresh the
 * screen with new images. This means the app will be asked to produce frames in more regular intervals,
 * potentially spending less time on frames that are likely to be dropped.
 *
 * For apps with heavy load, setting a well matching target framerate can improve the apps rendering stability
 * and reduce stutter.
 *
 * Likewise, the target framerate can be used to enable 120Hz refresh rates on Oculus Quest 2 on simpler apps.
 */
class TargetFramerate extends Component {
    static TypeName = 'target-framerate';
    framerate;
    onActivate() {
        this.engine.onXRSessionStart.add(this.setTargetFramerate);
    }
    onDeactivate() {
        this.engine.onXRSessionStart.remove(this.setTargetFramerate);
    }
    setTargetFramerate = (s) => {
        if (s.supportedFrameRates) {
            const a = s.supportedFrameRates;
            a.sort((a, b) => Math.abs(a - this.framerate) - Math.abs(b - this.framerate));
            s.updateTargetFrameRate(a[0]);
        }
    };
}
__decorate([
    property.float(90.0)
], TargetFramerate.prototype, "framerate", void 0);
export { TargetFramerate };
//# sourceMappingURL=target-framerate.js.map