var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@wonderlandengine/api';
import { property } from '@wonderlandengine/api/decorators.js';
/**
 * Set player height for a Y-offset above the ground for
 * 'local' and 'viewer' reference spaces.
 */
class PlayerHeight extends Component {
    static TypeName = 'player-height';
    height = 1.75;
    onSessionStartCallback;
    onSessionEndCallback;
    start() {
        this.object.resetPositionRotation();
        this.object.translateLocal([0.0, this.height, 0.0]);
        this.onSessionStartCallback = this.onXRSessionStart.bind(this);
        this.onSessionEndCallback = this.onXRSessionEnd.bind(this);
    }
    onActivate() {
        this.engine.onXRSessionStart.add(this.onSessionStartCallback);
        this.engine.onXRSessionEnd.add(this.onSessionEndCallback);
    }
    onDeactivate() {
        this.engine.onXRSessionStart.remove(this.onSessionStartCallback);
        this.engine.onXRSessionEnd.remove(this.onSessionEndCallback);
    }
    onXRSessionStart() {
        const type = this.engine.xr?.currentReferenceSpaceType;
        if (type !== 'local' && type !== 'viewer') {
            this.object.resetPositionRotation();
        }
    }
    onXRSessionEnd() {
        const type = this.engine.xr?.currentReferenceSpaceType;
        if (type !== 'local' && type !== 'viewer') {
            this.object.resetPositionRotation();
            this.object.translateLocal([0.0, this.height, 0.0]);
        }
    }
}
__decorate([
    property.float(1.75)
], PlayerHeight.prototype, "height", void 0);
export { PlayerHeight };
//# sourceMappingURL=player-height.js.map