var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, Emitter } from '@wonderlandengine/api';
import { property } from '@wonderlandengine/api/decorators.js';
import { setXRRigidTransformLocal } from './utils/webxr.js';
/**
 * Sets up a [WebXR Device API "Hit Test"](https://immersive-web.github.io/hit-test/)
 * and places the object to the hit location.
 *
 * **Requirements:**
 *  - Specify `'hit-test'` in the required or optional features on the AR button in your html file.
 *    See [Wastepaperbin AR](/showcase/wpb-ar) as an example.
 */
class HitTestLocation extends Component {
    static TypeName = 'hit-test-location';
    tempScaling = new Float32Array(3);
    visible = false;
    xrHitTestSource = null;
    /** Reference space for creating the hit test when the session starts */
    xrReferenceSpace = null;
    /**
     * For maintaining backwards compatibility: Whether to scale the object to 0 and back.
     * @deprecated Use onHitLost and onHitFound instead.
     */
    scaleObject = true;
    /** Emits an event when the hit test switches from visible to invisible */
    onHitLost = new Emitter();
    /** Emits an event when the hit test switches from invisible to visible */
    onHitFound = new Emitter();
    onSessionStartCallback = null;
    onSessionEndCallback = null;
    start() {
        this.onSessionStartCallback = this.onXRSessionStart.bind(this);
        this.onSessionEndCallback = this.onXRSessionEnd.bind(this);
        if (this.scaleObject) {
            this.tempScaling.set(this.object.scalingLocal);
            this.object.scale([0, 0, 0]);
            this.onHitLost.add(() => {
                this.tempScaling.set(this.object.scalingLocal);
                this.object.scale([0, 0, 0]);
            });
            this.onHitFound.add(() => {
                this.object.scalingLocal.set(this.tempScaling);
                this.object.setDirty();
            });
        }
    }
    onActivate() {
        this.engine.onXRSessionStart.add(this.onSessionStartCallback);
        this.engine.onXRSessionEnd.add(this.onSessionEndCallback);
    }
    onDeactivate() {
        this.engine.onXRSessionStart.remove(this.onSessionStartCallback);
        this.engine.onXRSessionEnd.remove(this.onSessionEndCallback);
    }
    update() {
        const wasVisible = this.visible;
        if (this.xrHitTestSource) {
            const frame = this.engine.xrFrame;
            if (!frame)
                return;
            let hitTestResults = frame.getHitTestResults(this.xrHitTestSource);
            if (hitTestResults.length > 0) {
                let pose = hitTestResults[0].getPose(this.engine.xr.currentReferenceSpace);
                this.visible = !!pose;
                if (pose) {
                    setXRRigidTransformLocal(this.object, pose.transform);
                }
            }
            else {
                this.visible = false;
            }
        }
        /* Emit events for visible state change */
        if (this.visible != wasVisible) {
            (this.visible ? this.onHitFound : this.onHitLost).notify(this);
        }
    }
    getHitTestResults(frame = this.engine.xr?.frame ?? null) {
        if (!frame)
            return [];
        /* May happen if the hit test source couldn't be created */
        if (!this.xrHitTestSource)
            return [];
        return frame.getHitTestResults(this.xrHitTestSource);
    }
    onXRSessionStart(session) {
        if (session.requestHitTestSource === undefined) {
            console.error('hit-test-location: hit test feature not available. Deactivating component.');
            this.active = false;
            return;
        }
        session
            .requestHitTestSource({
            space: this.xrReferenceSpace ??
                this.engine.xr.referenceSpaceForType('viewer'),
        })
            .then((hitTestSource) => {
            this.xrHitTestSource = hitTestSource;
        })
            .catch(console.error);
    }
    onXRSessionEnd() {
        if (!this.xrHitTestSource)
            return;
        this.xrHitTestSource.cancel();
        this.xrHitTestSource = null;
    }
}
__decorate([
    property.bool(true)
], HitTestLocation.prototype, "scaleObject", void 0);
export { HitTestLocation };
//# sourceMappingURL=hit-test-location.js.map