## 1.5.0

WebGPU support with full WebGL2 feature parity, probe volume scenarios,
runtime baking, and project import/export.

### WebGPU support

Wonderland 1.4.x had experimental WebGPU support, but we've upgraded
the WebGPU backend to support all features of the existing WebGL2
renderer.

WebGPU is now a first-class target for web applications in
Wonderland. Try it out in your favorite browser! If WebGPU is not
supported, Wonderland automatically falls back to WebGL2 with no
visual difference.

The focus of this release was visual feature parity, but expect
to see many performance and visual improvements as we make more and
more use of WebGPU's modern API.

### Probe volume scenarios

Probe volumes are a great way to get baked global illumination into your
project. However, managing multiple lighting scenarios (e.g. different season
or time of day) involved manually moving around files.

This is now a thing of the past! You can now create multiple probe volume
scenario resources, and then pick which scenario should be baked and which
should be used for global illumination.

### Changelog

**Editor**

- Add new probe volume scenario resource
- Add project file export and import. Exporting creates a new .wlp with the
  selected objects and all referenced resources. Importing merges an exported
  .wlp into the current project.
- Split probe volume voxelization and baking. You can now see the voxelization
  result before baking.
- Make probe volume baking cancellable. If restarted, resumes from where it
  was cancelled.
- Allow selecting WebGPU-only as rendering API
- Make shadow map size configurable, clamped at runtime to supported size
- Optimize Scene View debug visualization rendering
- Add `loadUncompressedImagesAsBitmap` runtime setting for loading uncompressed
  images as `ImageBitmap` (instead of `HTMLImageElement` etc.)
- Improve path handling for projects on different Windows drives

**Engine**

- Implement WebGPU rendering backend with full feature parity
- Avoid superfluous skinned mesh updates with multidraw enabled
- Package probe volume scenarios as delay-loaded .bin files
- Fix several shader warnings

**Runtime**

- Bundle all WebGPU-enabled variants of the runtime
- Use correct threaded runtime when WebGPU is enabled
- Fall back to WebGL2 runtime if WebGPU is not supported or initialization fails

**Editor API**

- Rename `project` to `workspace`
- Add `workspace.projects[]` for accessing per-project data

**JS API**

- Add `Environment.requestBake()` for baking environment from the current sky material
- Add `GLTFOptions.generateSimpleTangents` to generate trivial tangents instead
  of using mikktspace. Speeds up loading, but might produce rendering artifacts.
