import { world_tracker_quality_t as WorldTrackerQuality, zappar_world_tracker_t, plane_orientation_t as PlaneOrientation, anchor_status_t as AnchorStatus, world_scale_mode_t as WorldScaleMode } from '@zappar/zappar-cv';
import { Pipeline } from './pipeline.js';
import { Anchor } from './anchor.js';
import { Event, Event1 } from './event.js';
import { CustomAnchor } from './customanchor.js';
export { world_tracker_quality_t as WorldTrackerQuality, transform_orientation_t as TransformOrientation, plane_orientation_t as PlaneOrientation, anchor_status_t as AnchorStatus, world_scale_mode_t as WorldScaleMode, } from '@zappar/zappar-cv';
export interface WorldAnchor extends Anchor {
    id: string;
    status: AnchorStatus;
}
export interface PlaneAnchor extends WorldAnchor {
    polygon: Float32Array;
    polygonVersion: number;
    orientation: PlaneOrientation;
    firstPlane: boolean;
}
/**
 * Attaches content to a point on a surface in front of the user as it moves around in the camera view.
 * @see https://docs.zap.works/universal-ar/javascript/instant-world-tracking/
 */
export declare class WorldTracker {
    onQuality: Event1<WorldTrackerQuality>;
    onInitializing: Event;
    onQualityGood: Event;
    onQualityLimited: Event;
    quality: WorldTrackerQuality;
    worldAnchor: WorldAnchor;
    groundAnchor: WorldAnchor;
    planes: Map<string, PlaneAnchor>;
    customAnchors: Map<string, CustomAnchor>;
    resetIfLimitedForMS: number;
    /** @internal */
    readonly _pipeline: Pipeline;
    /** @internal */
    _impl: zappar_world_tracker_t;
    private _z;
    private _hadFirstPlane;
    private _limitedTimeout;
    /**
     * Constructs a new WorldTracker.
     * @param _pipeline - The pipeline that this tracker will operate within.
     */
    constructor(pipeline: Pipeline);
    /**
     * Destroys the world tracker.
     */
    destroy(): void;
    private _frameUpdate;
    reset(): void;
    /**
     * Gets/sets the enabled state of the world tracker.
     * Disable when not in use to save computational resources during frame processing.
     */
    get enabled(): boolean;
    set enabled(e: boolean);
    get horizontalPlaneDetectionEnabled(): boolean;
    set horizontalPlaneDetectionEnabled(v: boolean);
    get verticalPlaneDetectionEnabled(): boolean;
    set verticalPlaneDetectionEnabled(v: boolean);
    get verticalPlaneDetectionSupported(): boolean;
    get tracksDataEnabled(): boolean;
    set tracksDataEnabled(v: boolean);
    get projectionsDataEnabled(): boolean;
    get tracksData(): Float32Array;
    get projectionsData(): Float32Array;
    get scaleMode(): WorldScaleMode;
    set scaleMode(mode: WorldScaleMode);
    computePointsDataMatrix(screenWidth: number, screenHeight: number, mirror?: boolean): Float32Array;
}
