export function generateMeshForPlanePolygon(opts, polygon) {
    var _a;
    const boundaryVerticesSize = polygon.length / 2;
    const stride = 3 + 3 + 2 + 4; // 3 coords for vert, 3 for normals, 2 for uv, 4 for color
    const numberVertices = 1 + boundaryVerticesSize * (opts.fade ? 2 : 1);
    const vertexBuffer = new Float32Array(stride * numberVertices);
    const indexBuffer = new Uint16Array(boundaryVerticesSize * (opts.fade ? 3 : 1) * 3);
    const ret = {
        numberVertices,
        vertexBuffer,
        indexBuffer,
        stride,
        normalOffset: 3,
        uvOffset: 3 + 3,
        colorOffset: 3 + 3 + 2,
    };
    updateNoFade(ret, polygon);
    updateIndexBuffer(ret, (_a = opts.fade) !== null && _a !== void 0 ? _a : false, polygon);
    return ret;
}
function updateNoFade(mesh, polygon) {
    const numberPolygonVertices = polygon.length / 2;
    // Find average point
    const av = [0, 0];
    for (let i = 0; i < numberPolygonVertices; i += 2) {
        av[0] += polygon[i];
        av[1] += polygon[i + 1];
    }
    av[0] /= numberPolygonVertices;
    av[1] /= numberPolygonVertices;
    mesh.vertexBuffer[0] = av[0];
    mesh.vertexBuffer[1] = 0;
    mesh.vertexBuffer[2] = av[1];
    mesh.vertexBuffer[3] = 0;
    mesh.vertexBuffer[4] = 1;
    mesh.vertexBuffer[5] = 0;
    const uv = generateUV(av[0], av[1]);
    mesh.vertexBuffer[6] = uv[0];
    mesh.vertexBuffer[7] = uv[1];
    mesh.vertexBuffer[8] = 1.0;
    mesh.vertexBuffer[9] = 1.0;
    mesh.vertexBuffer[10] = 1.0;
    mesh.vertexBuffer[11] = 1.0;
    for (let i = 0; i < numberPolygonVertices; i++) {
        const av = [polygon[i * 2 + 0], polygon[i * 2 + 1]];
        mesh.vertexBuffer[mesh.stride * (i + 1) + 0] = av[0];
        mesh.vertexBuffer[mesh.stride * (i + 1) + 1] = 0;
        mesh.vertexBuffer[mesh.stride * (i + 1) + 2] = av[1];
        mesh.vertexBuffer[mesh.stride * (i + 1) + 3] = 0;
        mesh.vertexBuffer[mesh.stride * (i + 1) + 4] = 1;
        mesh.vertexBuffer[mesh.stride * (i + 1) + 5] = 0;
        const uv = generateUV(av[0], av[1]);
        mesh.vertexBuffer[mesh.stride * (i + 1) + 6] = uv[0];
        mesh.vertexBuffer[mesh.stride * (i + 1) + 7] = uv[1];
        mesh.vertexBuffer[mesh.stride * (i + 1) + 8] = 1.0;
        mesh.vertexBuffer[mesh.stride * (i + 1) + 9] = 1.0;
        mesh.vertexBuffer[mesh.stride * (i + 1) + 10] = 1.0;
        mesh.vertexBuffer[mesh.stride * (i + 1) + 11] = 1.0;
    }
}
function updateIndexBuffer(mesh, fade, polygon) {
    const numberBoundaryPoints = polygon.length / 2;
    let offset = 0;
    for (let i = 0; i < numberBoundaryPoints; i++) {
        mesh.indexBuffer[offset] = 0;
        offset++;
        mesh.indexBuffer[offset] = i + 1;
        offset++;
        mesh.indexBuffer[offset] = i + 2;
        offset++;
        if (fade) {
            mesh.indexBuffer[offset] = i + 1;
            offset++;
            mesh.indexBuffer[offset] = i + numberBoundaryPoints + 1;
            offset++;
            mesh.indexBuffer[offset] = i + numberBoundaryPoints + 2;
            offset++;
            mesh.indexBuffer[offset] = i + 1;
            offset++;
            mesh.indexBuffer[offset] = i + numberBoundaryPoints + 2;
            offset++;
            mesh.indexBuffer[offset] = i + 2;
            offset++;
        }
    }
    if (fade) {
        offset = 9 * (numberBoundaryPoints - 1);
        mesh.indexBuffer[offset + 2] = 1;
        mesh.indexBuffer[offset + 5] = numberBoundaryPoints + 1;
        mesh.indexBuffer[offset + 7] = numberBoundaryPoints + 1;
        mesh.indexBuffer[offset + 8] = 1;
    }
    else {
        offset = 3 * (numberBoundaryPoints - 1);
        mesh.indexBuffer[offset + 2] = 1;
    }
}
// const _vert = vec3.create();
function generateUV(x, z) {
    // _vert[0] = x; _vert[1] = 0; _vert[2] = z;
    // vec3.transformMat4(_vert, _vert, worldTransform);
    return [x, -z];
}
