import { Event, Event1 } from './event.js';
import { Pipeline } from './pipeline.js';
import { Anchor } from './anchor.js';
export declare enum D3Type {
    QR = 0,
    DENSE = 1
}
export interface D3BaseAnchor extends Anchor {
    /**
     * Emitted when the anchor becomes visible in a camera frame.
     */
    onVisible: Event;
    /**
     * Emitted when the anchor goes from being visible in the previous camera frame, to not being visible in the current frame.
     */
    onNotVisible: Event;
    id: string;
    visible: boolean;
    pose0(cameraPose: Float32Array, mirror?: boolean): Float32Array;
    pose0CameraRelative(mirror?: boolean): Float32Array;
    pose1(cameraPose: Float32Array, mirror?: boolean): Float32Array;
    pose1CameraRelative(mirror?: boolean): Float32Array;
}
export interface D3QRAnchor extends D3BaseAnchor {
    type: D3Type.QR;
    url: string;
    category: number;
}
export interface D3DenseAnchor extends D3BaseAnchor {
    type: D3Type.DENSE;
    value: number;
}
export type D3Anchor = D3QRAnchor | D3DenseAnchor;
/**
 * Attaches content to a D3 Marker
 */
export declare class D3Tracker {
    private _pipeline;
    /**
     * Emitted when an anchor becomes visible in a camera frame.
     */
    onVisible: Event1<D3Anchor>;
    /**
     * Emitted when an anchor goes from being visible in the previous camera frame, to not being visible in the current frame.
     */
    onNotVisible: Event1<D3Anchor>;
    /**
     * Emitted when a new anchor is created by the tracker.
     */
    onNewAnchor: Event1<D3Anchor>;
    /**
     * The set of currently visible anchors.
     */
    visible: Set<D3Anchor>;
    anchors: Map<string, D3Anchor>;
    private _visibleLastFrame;
    private _z;
    private _impl;
    private _processMaxResolution;
    constructor(_pipeline: Pipeline);
    destroy(): void;
    private _frameUpdate;
    /**
     * Gets/sets the enabled state of the image tracker.
     * Disable when not in use to save computational resources during frame processing.
     */
    get enabled(): boolean;
    set enabled(e: boolean);
    set processMaxResolution(value: boolean);
    get processMaxResolution(): boolean;
    setSizeForID(id: string, size: number): void;
}
