import { TransformOrientation } from './worldtracker.js';
import { z } from './zappar.js';
let numberCustomAnchors_ = 0;
export class CustomAnchor {
    constructor(_worldTracker, id) {
        this._worldTracker = _worldTracker;
        this._z = z();
        if (!id) {
            this.id = 'custom-anchor-' + numberCustomAnchors_.toString();
            numberCustomAnchors_++;
        }
        else {
            this.id = id;
        }
        _worldTracker.customAnchors.set(this.id, this);
        this._impl = this._z.custom_anchor_create(_worldTracker._pipeline._getImpl(), this._worldTracker._impl, this.id);
    }
    /**
     * Destroys the world tracker.
     */
    destroy() {
        this._z.custom_anchor_destroy(this._impl);
    }
    pose(cameraPose, mirror) {
        return this._z.custom_anchor_pose(this._impl, cameraPose, mirror !== null && mirror !== void 0 ? mirror : false);
    }
    poseCameraRelative(mirror) {
        return this._z.custom_anchor_pose_camera_relative(this._impl, mirror !== null && mirror !== void 0 ? mirror : false);
    }
    setPoseFromCameraOffset(x, y, z, orientation = TransformOrientation.UNCHANGED) {
        this._z.custom_anchor_pose_set_from_camera_offset(this._impl, x, y, z, orientation);
    }
    setPoseFromAnchorOffset(anchor, x, y, z, orientation = TransformOrientation.UNCHANGED) {
        const anchor_id = typeof anchor === 'string' ? anchor : anchor.id;
        this._z.custom_anchor_pose_set_from_anchor_offset(this._impl, anchor_id, x, y, z, orientation);
    }
    /**
     * Set the pose in 3D space that this custom anchor is tracked to. It should be specified in the
     * coordinate system of the world tracker's world anchor.
     *
     * @param pose - a 4x4 column major pose matrix
     */
    setPose(pose) {
        this._z.custom_anchor_pose_set(this._impl, pose);
    }
    /**
     * Set the pose in 3D space that this custom anchor is tracked to. It should be specified in the
     * coordinate system of the world tracker's world anchor. Unlike `setPose`, this variant allows you to specify
     * another anchor (such as a plane anchor) that this custom anchor is relative to. For some implementations
     * this may improve tracking performance.
     *
     * @param pose - a 4x4 column major pose matrix
     * @param parent_anchor - the parent anchor (or its ID)
     */
    setPoseWithParent(pose, parent_anchor) {
        const parent_anchor_id = typeof parent_anchor === 'string' ? parent_anchor : parent_anchor.id;
        this._z.custom_anchor_pose_set_with_parent(this._impl, pose, parent_anchor_id);
    }
    get status() {
        return this._z.custom_anchor_status(this._impl);
    }
}
