import { AnchorStatus, TransformOrientation, WorldAnchor, WorldTracker } from './worldtracker.js';
export declare class CustomAnchor implements WorldAnchor {
    private _worldTracker;
    id: string;
    private _z;
    private _impl;
    constructor(_worldTracker: WorldTracker, id?: string);
    /**
     * Destroys the world tracker.
     */
    destroy(): void;
    pose(cameraPose: Float32Array, mirror?: boolean): Float32Array;
    poseCameraRelative(mirror?: boolean | undefined): Float32Array;
    setPoseFromCameraOffset(x: number, y: number, z: number, orientation?: TransformOrientation): void;
    setPoseFromAnchorOffset(anchor: WorldAnchor | string, x: number, y: number, z: number, orientation?: TransformOrientation): void;
    /**
     * Set the pose in 3D space that this custom anchor is tracked to. It should be specified in the
     * coordinate system of the world tracker's world anchor.
     *
     * @param pose - a 4x4 column major pose matrix
     */
    setPose(pose: Float32Array): void;
    /**
     * Set the pose in 3D space that this custom anchor is tracked to. It should be specified in the
     * coordinate system of the world tracker's world anchor. Unlike `setPose`, this variant allows you to specify
     * another anchor (such as a plane anchor) that this custom anchor is relative to. For some implementations
     * this may improve tracking performance.
     *
     * @param pose - a 4x4 column major pose matrix
     * @param parent_anchor - the parent anchor (or its ID)
     */
    setPoseWithParent(pose: Float32Array, parent_anchor: WorldAnchor | string): void;
    get status(): AnchorStatus;
}
