import { z } from './zappar.js';
import { camera_profile_t } from '@zappar/zappar-cv';
/**
 * Creates a source of frames from a device camera.
 * @see https://docs.zap.works/universal-ar/javascript/pipelines-and-camera-processing/
 */
export class CameraSource {
    /**
     * Constructs a new CameraSource.
     * @param _pipeline - The pipeline that this tracker will operate within.
     * @param deviceId - The camera device ID which will be used as the source.
     * @see https://docs.zap.works/universal-ar/javascript/pipelines-and-camera-processing/
     */
    constructor(pipeline, deviceId) {
        this._profile = camera_profile_t.DEFAULT;
        this._z = z();
        this._impl = this._z.camera_source_create(pipeline._getImpl(), deviceId);
    }
    /**
     * Destroys the camera source.
     */
    destroy() {
        this._z.camera_source_destroy(this._impl);
    }
    /**
     * Starts the camera source.
     *
     * Starting a given source pauses any other sources within the same pipeline.
     */
    start() {
        this._z.camera_source_start(this._impl);
    }
    /**
     * Pauses the camera source.
     */
    pause() {
        this._z.camera_source_pause(this._impl);
    }
    set profile(p) {
        this._profile = p;
        this._z.camera_source_profile_set(this._impl, p);
    }
    get profile() {
        return this._profile;
    }
}
