var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var _a;
import { MsgManager } from "./messages";
export let messageManager = new MsgManager();
const params = new URLSearchParams(window.location.search);
const shouldRecordData = parseInt((_a = params.get('_zrecorddata')) !== null && _a !== void 0 ? _a : '0');
const wasmModule = (() => __awaiter(void 0, void 0, void 0, function* () {
    const response = yield fetch(new URL("./zappar-cv.wasm", import.meta.url).toString());
    const module = yield WebAssembly.compileStreaming(response);
    return module;
}))();
export function launchWorker(worker) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!worker)
            worker = new Worker(new URL("./worker", import.meta.url), { type: 'module' });
        worker.postMessage({
            t: "wasm",
            url: new URL("./zappar-cv.wasm", import.meta.url).toString(),
            module: yield wasmModule,
            shouldRecordData
        });
        yield waitForLoad(worker);
        function sendOutgoing() {
            let msgs = messageManager.getOutgoingMessages();
            for (let msg of msgs) {
                worker.postMessage(msg.msg, msg.transferables);
            }
        }
        messageManager.onOutgoingMessage.bind(sendOutgoing);
        sendOutgoing();
        worker.addEventListener("message", evt => {
            messageManager.postIncomingMessage(evt.data);
        });
    });
}
export function launchCeresWorkers(port0, port1, worker0, worker1) {
    return __awaiter(this, void 0, void 0, function* () {
        {
            if (!worker0)
                worker0 = new Worker(new URL("./ceres-worker", import.meta.url), { type: 'module' });
            worker0.postMessage({
                t: "wasm",
                url: new URL("./zappar-cv.wasm", import.meta.url).toString(),
                module: yield wasmModule,
                port: port0,
                instance: 0,
            }, [port0]);
        }
        {
            if (!worker1)
                worker1 = new Worker(new URL("./ceres-worker", import.meta.url), { type: 'module' });
            worker1.postMessage({
                t: "wasm",
                url: new URL("./zappar-cv.wasm", import.meta.url).toString(),
                module: yield wasmModule,
                port: port1,
                instance: 1,
            }, [port1]);
        }
    });
}
function waitForLoad(w) {
    return new Promise(resolve => {
        let listener = (msg) => {
            if (msg.data === "loaded") {
                w.removeEventListener("message", listener);
                resolve();
            }
        };
        w.addEventListener("message", listener);
    });
}
