import { anchor_status_t, world_tracker_quality_t, camera_profile_t, zappar_camera_source_t, zappar_pipeline_t, zappar_custom_anchor_t } from "./gen/zappar";
import { CameraFrameInfo, Source } from "./source";
export interface WebXRPlaneAnchorData {
    id: string;
    horizontal: boolean;
    status: anchor_status_t;
    pose: Float32Array;
    boundary: Float32Array;
    boundaryVersion: number;
}
export interface WebXRCustomAnchorData {
    id: number;
    status: anchor_status_t;
    pose: Float32Array;
    poseVersion: number;
}
export interface WebXRWTData {
    world_anchor_status: anchor_status_t;
    world_anchor_pose: Float32Array;
    ground_anchor_status: anchor_status_t;
    ground_anchor_pose: Float32Array;
    plane_anchors: WebXRPlaneAnchorData[];
    custom_anchors: WebXRCustomAnchorData[];
    quality: world_tracker_quality_t;
}
export interface WebXRWTOptions {
    horizontalPlaneDetection: boolean;
    verticalPlaneDetection: boolean;
}
export declare class WebXRCameraSource extends Source {
    private _impl;
    private _pipeline;
    sessionNumber: number;
    private _isPaused;
    private _xrSession;
    private _xrLocalSpace;
    private _xrViewerSpace;
    private _xrGlBinding;
    private _xrWebGLLayer;
    private _offscreenCanvas;
    private _offscreenContext;
    private _imageBlitGl;
    private _latestFrame;
    private _latestWtData;
    private _wtOptions;
    private _lastFrameTime;
    private _cameraToDeviceTransform;
    private _cameraModel;
    private _rawCameraModel;
    private _profile;
    private _permissionRequestShown;
    private _planeHitTestSource;
    private _customAnchorSetRequests;
    private _customAnchors;
    private _groundH;
    static IsSupported(): boolean;
    constructor(_impl: zappar_camera_source_t, _pipeline: zappar_pipeline_t);
    destroy(): void;
    setProfile(p: camera_profile_t): void;
    private _stop;
    pause(): void;
    start(): void;
    optionsUpdated(options: WebXRWTOptions): void;
    resetTracking(): void;
    getFrame(currentlyProcessing: boolean): void;
    private _syncCamera;
    private _onXRFrame;
    private _onXREnd;
    private _hasStartedOrientation;
    private _lastTimestamp;
    private _deviceMotionListener;
    private _startDeviceOrientation;
    private _startDeviceMotion;
    private _stopDeviceMotion;
    uploadGL(info: CameraFrameInfo): void;
    setCustomAnchorPose(o: zappar_custom_anchor_t, version: number, pose: Float32Array): Promise<void>;
    deleteCustomAnchor(o: zappar_custom_anchor_t): Promise<void>;
    private _updateCameraModel;
    private _isPlaneVertical;
}
