/// <reference types="dom-webcodecs" />
export interface CameraFrameInfo {
    rgbFrame?: ImageBitmap | VideoFrame | ImageData;
    data?: ArrayBuffer;
    texture: WebGLTexture | undefined;
    dataWidth: number;
    dataHeight: number;
    cameraModel: Float32Array;
    cameraToDevice: Float32Array;
    cameraSource: Source;
    cameraSourceData?: any;
    uvTransform?: Float32Array;
    userFacing: boolean;
    remoteToken?: number;
    frame?: VideoFrame | ImageBitmap;
}
export declare abstract class Source {
    abstract getFrame(currentlyProcessing: boolean): void;
    abstract pause(): void;
    abstract uploadGL(info: CameraFrameInfo): void;
    recycle?(info: CameraFrameInfo): void;
}
