import { camera_profile_t, zappar_camera_source_t, zappar_pipeline_t } from "./gen/zappar";
import { CameraFrameInfo, Source } from "./source";
export declare class MSTPCameraSource extends Source {
    private _impl;
    private _pipeline;
    private _deviceId;
    static USER_DEFAULT_DEVICE_ID: string;
    static DEFAULT_DEVICE_ID: string;
    private _currentStream;
    private _activeDeviceId;
    private _isPaused;
    private _isUserFacing;
    private _cameraToScreenRotation;
    private _accelerometer?;
    private _linearAcceleration?;
    private _gyroscope?;
    private _relativeOrientation?;
    constructor(_impl: zappar_camera_source_t, _pipeline: zappar_pipeline_t, _deviceId: string);
    destroy(): void;
    private _stop;
    pause(): void;
    start(): void;
    private _getConstraints;
    getFrame(allowRead: boolean): void;
    private _getUserMedia;
    streamEnded(): void;
    private _syncCamera;
    setProfile(profile: camera_profile_t): void;
    private _hasStartedOrientation;
    private _lastTimestamp;
    private _deviceMotionListener;
    private _startDeviceOrientation;
    private _startDeviceMotion;
    private _lastAccelerometerTimestamp;
    private _accelerometerReading;
    private _lastLinearAccelerationTimestamp;
    private _linearAccelerationReading;
    private _lastGyroscopeReading;
    private _gyroscopeReading;
    private _lastReleativeOrientationReading;
    private _relativeOrientationReading;
    private _stopDeviceMotion;
    uploadGL(info: CameraFrameInfo): void;
}
