import { BridgedMessage } from "./bridged-message";
export declare const BridgeArrayBufferHeader_u32: number;
export interface ParsedBridgeArrayBuffer {
    replyID: number;
    json: BridgedMessage;
    uint8ArrayForBinaryBufferOffset: (offset: number, length: number) => Uint8Array;
    uint32ArrayForBinaryBufferOffset: (offset: number, length: number) => Uint32Array;
    floatArrayForBinaryBufferOffset: (offset: number, length: number) => Float32Array;
}
export declare function hasBridgeArrayBufferHeader(str: string): boolean;
export declare function replyIdFromBridgeArrayBuffer(str: string): number;
export declare function parseBridgeArrayBuffer(ab: ArrayBuffer): ParsedBridgeArrayBuffer | undefined;
