/// <reference types="dom-webcodecs" />
import { zappar_pipeline_t, zappar_camera_source_t } from "./gen/zappar";
import { camera_profile_t } from "./gen/zappar-native";
import { zappar_client } from "./gen/zappar-client";
import { MsgManager } from "./messages";
import { Source, CameraFrameInfo } from "./source";
import { CameraDataRawS2C, CameraFrameReturnS2C, ImageBitmapS2C, VideoFrameS2C } from "./workerinterface";
import { FaceMesh } from "./facemesh";
import { Event } from "./event";
import { ImageTracker } from "./imagetracker";
import { zappar } from "./gen/zappar-bridge";
import { CameraFrameData, CameraFrameDataRGB } from "./camera-frame-data";
export declare class Pipeline {
    private _client;
    private _impl;
    private _mgr;
    currentCameraSource: Source | undefined;
    pendingMessages: any[];
    private cameraTokens;
    private nextCameraToken;
    private tokensInFlight;
    glContext: WebGLRenderingContext | WebGL2RenderingContext | undefined;
    private videoTextures;
    cameraPixelArrays: ArrayBuffer[];
    private _cameraDraw;
    private _faceDraw;
    private _imageTargetPreviewDraw;
    private _faceProjectDraw;
    private _sequenceRecorder;
    private _sequenceRecordDeviceAttitudeMatrices;
    private _sequenceRecorderFirstCameraToken;
    private _cameraFrameDataPromises;
    private _cameraFrameDataResolves;
    private _cameraFrameDataRejects;
    private _cameraFrameDataEnabled;
    private _cameraFrameDataRGBEnabled;
    onGLContextReset: Event;
    static create(client: zappar, mgr: MsgManager): zappar_pipeline_t;
    static get(p: zappar_pipeline_t): Pipeline | undefined;
    private constructor();
    frameUpdate(client: zappar_client): void;
    cleanOldFrames(): void;
    cameraFrameDataRawResult(msg: CameraDataRawS2C): void;
    cameraTokenReturn(msg: CameraFrameReturnS2C): void;
    sequenceRecordStart(expectedFrames: number): void;
    sequenceRecordStop(): void;
    sequenceRecordData(): Uint8Array;
    sequenceRecordClear(): void;
    sequenceRecordDeviceAttitudeMatrices(v: boolean): void;
    getVideoTexture(): WebGLTexture | undefined;
    getCameraFrameDataRGB(): CameraFrameDataRGB | undefined;
    setCameraFrameDataRGBEnabled(e: boolean): void;
    getCameraFrameDataRGBEnabled(): boolean;
    getCameraFrameDataRaw(): Promise<CameraFrameData | undefined>;
    setCameraFrameDataRawEnabled(e: boolean): void;
    destroy(): void;
    getCurrentCameraInfo(): CameraFrameInfo | undefined;
    cameraFrameDrawGL(screenWidth: number, screenHeight: number, mirror?: boolean): void;
    glContextLost(): void;
    glContextSet(gl: WebGLRenderingContext, texturePool?: WebGLTexture[]): void;
    drawFace(projectionMatrix: Float32Array, cameraMatrix: Float32Array, targetMatrix: Float32Array, o: FaceMesh): void;
    drawImageTargetPreview(projectionMatrix: Float32Array, cameraMatrix: Float32Array, targetMatrix: Float32Array, indx: number, o: ImageTracker): void;
    drawFaceProject(matrix: Float32Array, vertices: Float32Array, uvMatrix: Float32Array, uvs: Float32Array, indices: Uint16Array, texture: WebGLTexture): void;
    cameraFrameTexture(): WebGLTexture | undefined;
    cameraFrameTextureMatrix(sw: number, sh: number, mirror: boolean): Float32Array;
    cameraFrameUserFacing(): boolean;
    cameraPoseWithAttitude(mirror: boolean): Float32Array;
    videoFrameFromWorker(msg: VideoFrameS2C): void;
    imageBitmapFromWorker(msg: ImageBitmapS2C): void;
    uploadGL(): void;
    registerToken(info: CameraFrameInfo): number;
    processGL(): void;
    motionAccelerometerSubmit(timestamp: number, x: number, y: number, z: number): void;
    motionAccelerometerWithoutGravitySubmitInt(timestamp: number, interval: number, x: number, y: number, z: number): void;
    motionAccelerometerWithGravitySubmitInt(timestamp: number, interval: number, x: number, y: number, z: number): void;
    motionRotationRateSubmitInt(timestamp: number, interval: number, x: number, y: number, z: number): void;
    motionAttitudeSubmitInt(timestamp: number, interval: number, x: number, y: number, z: number): void;
    motionRelativeOrientationSubmitInt(timestamp: number, interval: number, x: number, y: number, z: number, w: number): void;
    motionRotationRateSubmit(timestamp: number, x: number, y: number, z: number): void;
    motionAttitudeSubmit(timestamp: number, x: number, y: number, z: number): void;
    motionAttitudeMatrix(m: Float32Array): void;
    sendCameraStreamToWorker(source: zappar_camera_source_t, stream: ReadableStream<VideoFrame>, userFacing: boolean): void;
    sendCameraProfileToWorker(source: zappar_camera_source_t, profile: camera_profile_t): void;
    sendCameraToScreenRotationToWorker(rot: number): void;
    sendImageBitmapToWorker(img: ImageBitmap, rot: number, userFacing: boolean, tokenId: number, cameraModel: Float32Array, cameraToDevice: Float32Array, cp: camera_profile_t): void;
    sendDataToWorker(data: ArrayBuffer, token: number, width: number, height: number, userFacing: boolean, cameraToDevice: Float32Array, cameraModel: Float32Array, captureTime: number): void;
}
export declare function applyScreenCounterRotation(info: CameraFrameInfo | undefined, inp: Float32Array): Float32Array;
