var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { transform_orientation_t, image_target_type_t, anchor_status_t } from "./gen/zappar";
import { zappar_client } from "./gen/zappar-client";
import { drawPlane } from "./drawplane";
import { cameraRotationForScreenOrientation, projectionMatrixFromModelAndSize } from "./cameramodel";
import { mat4, vec3 } from "gl-matrix";
import { launchCeresWorkers, launchWorker, messageManager } from "./worker-client";
import { permissionRequestUI, permissionGrantedAll, permissionGrantedCamera, permissionGrantedMotion, permissionDeniedAny, permissionDeniedCamera, permissionDeniedMotion, permissionRequestMotion, permissionRequestCamera, permissionRequestAll, permissionDeniedUI, setWebXRSupported } from "./permission";
import { createFaceMesh, destroyFaceMesh, getFaceMesh } from "./facemesh";
import { Pipeline, applyScreenCounterRotation } from "./pipeline";
import { CameraSource } from "./camera-source";
import { HTMLElementSource } from "./html-element-source";
import { createFaceLandmark, destroyFaceLandmark, getFaceLandmark } from "./facelandmark";
import compatibility from './compatibility';
import { setLogLevel, zcwarn, zcout } from "./loglevel";
import { SequenceSource } from "./sequencesource";
import { createCameraSource, getCameraSource } from "./camera-source-map";
import { gfx } from "./gfx";
import { ImageTracker } from "./imagetracker";
import { MSTPCameraSource } from "./mstp-camera-source";
import { drawGrid } from "./drawgrid";
import { getPointsDataMatrix } from "./drawpoints";
import { drawAxis } from "./drawaxis";
import { BridgedWorldTracker } from "./bridged-world-tracker";
import { BridgedD3Tracker } from "./bridged-d3-tracker";
import { BridgedCameraSource } from "./bridged-camera-source";
import { WebXRCameraSource } from "./webxr-camera-source";
import { WebXRWorldTracker } from "./webxr-world-tracker";
let client;
const pipelineByWorldTracker = new Map();
const _temporaryMatrix = mat4.create();
const _temporaryVec3 = vec3.create();
export function initialize(opts) {
    if (client)
        return client;
    let loaded = false;
    launchWorker(opts === null || opts === void 0 ? void 0 : opts.worker).then(() => {
        zcout("Fully loaded");
        loaded = true;
    });
    let c = new zappar_client(ab => {
        messageManager.postOutgoingMessage({
            t: "zappar",
            d: ab
        }, [ab]);
    });
    const uid = getUID();
    let hasPersistedUID = false;
    let preferWebXRCamera = window.location.href.indexOf("_webxrcamera") >= 0;
    if ((opts === null || opts === void 0 ? void 0 : opts.preferWebXRCamera) !== undefined)
        preferWebXRCamera = opts.preferWebXRCamera;
    if (preferWebXRCamera && WebXRCameraSource.IsSupported()) {
        setWebXRSupported(true);
    }
    let hasSetID = false;
    try {
        /** @ts-ignore */
        const cookies = Object.fromEntries(document.cookie.split('; ').map(v => v.split(/=(.*)/s).map(decodeURIComponent)));
        if (cookies['zw-uar-project']) {
            const parsed = JSON.parse(cookies['zw-uar-project']);
            if (typeof parsed === 'object' && typeof parsed['id'] === 'string') {
                c.impl.analytics_project_id_set(".wiz" + parsed['id'], uid);
                hasSetID = true;
            }
        }
    }
    catch (err) { }
    if (!hasSetID) {
        if (window.location.hostname.toLowerCase().indexOf(".zappar.io") > 0 || window.location.hostname.toLowerCase().indexOf(".webar.run") > 0 || window.location.hostname.toLowerCase().indexOf(".arweb.app") > 0 || window.location.hostname.toLowerCase().indexOf(".zappar-us.io") > 0 || window.location.hostname.toLowerCase().indexOf(".zappar-eu.io") > 0) {
            let pathParts = window.location.pathname.split("/");
            if (pathParts.length > 1 && pathParts[1].length > 0) {
                c.impl.analytics_project_id_set(".wiz" + pathParts[1], uid);
                hasSetID = true;
            }
        }
    }
    messageManager.onIncomingMessage.bind(msg => {
        var _a, _b, _c, _d, _e, _f, _g, _h;
        switch (msg.t) {
            case "zappar":
                (_a = Pipeline.get(msg.p)) === null || _a === void 0 ? void 0 : _a.pendingMessages.push(msg.d);
                break;
            case "buf":
                c.serializer.bufferReturn(msg.d);
                break;
            case "cameraFrameRecycleS2C": {
                let msgt = msg;
                (_c = (_b = Pipeline.get(msgt.p)) === null || _b === void 0 ? void 0 : _b.cameraTokenReturn) === null || _c === void 0 ? void 0 : _c.call(_b, msg);
                break;
            }
            case "videoFrameS2C": {
                let msgt = msg;
                (_e = (_d = Pipeline.get(msgt.p)) === null || _d === void 0 ? void 0 : _d.videoFrameFromWorker) === null || _e === void 0 ? void 0 : _e.call(_d, msgt);
                break;
            }
            case "imageBitmapS2C": {
                let msgt = msg;
                (_g = (_f = Pipeline.get(msgt.p)) === null || _f === void 0 ? void 0 : _f.imageBitmapFromWorker) === null || _g === void 0 ? void 0 : _g.call(_f, msgt);
                break;
            }
            case "raw": {
                let msgt = msg;
                (_h = Pipeline.get(msgt.p)) === null || _h === void 0 ? void 0 : _h.cameraFrameDataRawResult(msgt);
                break;
            }
            case "streamEndedS2C": {
                let msgt = msg;
                const src = getCameraSource(msgt.source);
                if (src instanceof MSTPCameraSource)
                    src.streamEnded();
                break;
            }
            case "setupCeresWorker": {
                launchCeresWorkers(msg.port0, msg.port1, opts === null || opts === void 0 ? void 0 : opts.ceresWorker0, opts === null || opts === void 0 ? void 0 : opts.ceresWorker1);
                break;
            }
            case "_z_datadownload": {
                let blob = new Blob([msg.data], { type: "application/octet-stream" });
                let url = URL.createObjectURL(blob);
                let a = document.createElement("a");
                a.download = "sequencedata.bin";
                a.href = url;
                a.click();
                break;
            }
            case "licerr": {
                let div = document.createElement("div");
                div.innerHTML = "Visit <a href='https://docs.zap.works/universal-ar/licensing/' style='color: white;'>our licensing page</a> to find out about hosting on your own domain.";
                div.style.position = "absolute";
                div.style.bottom = "20px";
                div.style.width = "80%";
                div.style.backgroundColor = "black";
                div.style.color = "white";
                div.style.borderRadius = "10px";
                div.style.padding = "10px";
                div.style.fontFamily = "sans-serif";
                div.style.textAlign = "center";
                div.style.left = "10%";
                div.style.zIndex = Number.MAX_SAFE_INTEGER.toString();
                let span = document.createElement("span");
                span.innerText = " (30)";
                div.append(span);
                let indx = 30;
                setInterval(function () {
                    indx--;
                    if (indx >= 0)
                        span.innerText = " (" + indx.toString() + ")";
                }, 1000);
                document.body.append(div);
            }
            case "gfx": {
                let div = document.createElement("div");
                div.innerHTML = gfx;
                div.style.position = "absolute";
                div.style.bottom = "20px";
                div.style.width = "250px";
                div.style.left = "50%";
                div.style.marginLeft = "-125px";
                div.style.zIndex = Number.MAX_SAFE_INTEGER.toString();
                div.style.opacity = "0";
                div.style.transition = "opacity 0.5s";
                document.body.append(div);
                setTimeout(function () {
                    div.style.opacity = "1";
                }, 500);
                setTimeout(function () {
                    div.style.opacity = "0";
                }, 3000);
                setTimeout(function () {
                    div.remove();
                }, 4000);
            }
        }
    });
    const customAnchors = new Map();
    // Override world tracking functions if WebXR or the bridge is available
    let bridgedWtApi;
    let bridgedD3Api;
    if (preferWebXRCamera && WebXRCameraSource.IsSupported()) {
        bridgedWtApi = WebXRWorldTracker.SharedInstance();
    }
    else if (BridgedWorldTracker.IsSupported()) {
        bridgedWtApi = BridgedWorldTracker.SharedInstance();
        bridgedD3Api = BridgedD3Tracker.SharedInstance();
    }
    let bridgedWtImpl = (bridgedWtApi === null || bridgedWtApi === void 0 ? void 0 : bridgedWtApi.impl) || {};
    const wtImpl = (bridgedWtApi === null || bridgedWtApi === void 0 ? void 0 : bridgedWtApi.impl) || c.impl;
    let bridgedD3Impl = (bridgedD3Api === null || bridgedD3Api === void 0 ? void 0 : bridgedD3Api.impl) || {};
    client = Object.assign(Object.assign(Object.assign(Object.assign(Object.assign({}, c.impl), { world_tracker_mesh_anchor_count: () => 0, world_tracker_mesh_anchor_id: () => "", world_tracker_mesh_anchor_indices: () => new Uint32Array(0), world_tracker_mesh_anchor_indices_count: () => 0, world_tracker_mesh_anchor_indices_size: () => 0, world_tracker_mesh_anchor_vertices: () => new Float32Array(0), world_tracker_mesh_anchor_vertices_count: () => 0, world_tracker_mesh_anchor_vertices_size: () => 0, world_tracker_mesh_anchor_vertices_offset: () => 0, world_tracker_mesh_anchor_vertices_stride: () => 0, world_tracker_mesh_anchor_pose_raw: () => new Float32Array(), world_tracker_mesh_anchor_status: () => anchor_status_t.ANCHOR_STATUS_STOPPED, world_tracker_mesh_anchors_enabled: () => false, world_tracker_mesh_anchors_enabled_set: () => { }, d3_tracker_create: (p) => { return -1; }, d3_tracker_destroy: (o) => { }, d3_tracker_count: (o) => { return 0; }, d3_tracker_enabled: (o) => { return false; }, d3_tracker_enabled_set: (o, v) => { }, d3_tracker_process_max_resolution_set: (o, v) => { }, d3_tracker_pose_raw: (o, indx) => { return mat4.create(); }, d3_tracker_pose0_raw: (o, indx) => { return mat4.create(); }, d3_tracker_pose1_raw: (o, indx) => { return mat4.create(); }, d3_tracker_id: (o, indx) => { return ''; }, d3_tracker_qr: (o, indx) => { return ''; }, d3_tracker_landmarks_data: (o, indx) => { return new Float32Array(0); }, d3_tracker_landmarks_data_size: (o, indx) => { return 0; }, d3_tracker_type: (o, indx) => { return 0; }, d3_tracker_dense: (o, indx) => { return 0; }, d3_tracker_category: (o, indx) => { return 0; }, d3_tracker_size_for_id_set: (o, id, size) => { return 0; }, d3_tracker_pose: (o, indx, cameraPose, mirror) => {
            let res = applyScreenCounterRotation(undefined, client.d3_tracker_pose_raw(o, indx));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            mat4.multiply(res, cameraPose, res);
            return res;
        }, d3_tracker_pose_camera_relative: (o, indx, mirror) => {
            let res = applyScreenCounterRotation(undefined, client.d3_tracker_pose_raw(o, indx));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            return res;
        }, d3_tracker_pose0: (o, indx, cameraPose, mirror) => {
            let res = applyScreenCounterRotation(undefined, client.d3_tracker_pose0_raw(o, indx));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            mat4.multiply(res, cameraPose, res);
            return res;
        }, d3_tracker_pose0_camera_relative: (o, indx, mirror) => {
            let res = applyScreenCounterRotation(undefined, client.d3_tracker_pose0_raw(o, indx));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            return res;
        }, d3_tracker_pose1: (o, indx, cameraPose, mirror) => {
            let res = applyScreenCounterRotation(undefined, client.d3_tracker_pose1_raw(o, indx));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            mat4.multiply(res, cameraPose, res);
            return res;
        }, d3_tracker_pose1_camera_relative: (o, indx, mirror) => {
            let res = applyScreenCounterRotation(undefined, client.d3_tracker_pose1_raw(o, indx));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            return res;
        } }), bridgedWtImpl), bridgedD3Impl), { loaded: () => loaded, camera_default_device_id: userFacing => userFacing ? CameraSource.USER_DEFAULT_DEVICE_ID : CameraSource.DEFAULT_DEVICE_ID, camera_source_create: (p, deviceId) => createCameraSource(p, deviceId, preferWebXRCamera), camera_source_destroy: cam => { var _a; return (_a = getCameraSource(cam)) === null || _a === void 0 ? void 0 : _a.destroy(); }, camera_source_pause: cam => { var _a; return (_a = getCameraSource(cam)) === null || _a === void 0 ? void 0 : _a.pause(); }, camera_source_start: cam => { var _a; return (_a = getCameraSource(cam)) === null || _a === void 0 ? void 0 : _a.start(); }, camera_source_profile_set: (cam, p) => { var _a; return (_a = getCameraSource(cam)) === null || _a === void 0 ? void 0 : _a.setProfile(p); }, camera_count: () => 2, camera_id: indx => indx === 0 ? CameraSource.DEFAULT_DEVICE_ID : CameraSource.USER_DEFAULT_DEVICE_ID, camera_name: indx => indx === 0 ? "Rear-facing Camera" : "User-facing Camera", camera_user_facing: indx => indx !== 0, pose_from_raw: (raw_pose, mirror) => {
            let res = applyScreenCounterRotation(undefined, raw_pose);
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            return res;
        }, pipeline_create: () => Pipeline.create(c.impl, messageManager), pipeline_frame_update: (p) => { var _a; return (_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.frameUpdate(c); }, pipeline_camera_frame_draw_gl: (pipeline, screenWidth, screenHeight, mirror) => {
            var _a;
            (_a = Pipeline.get(pipeline)) === null || _a === void 0 ? void 0 : _a.cameraFrameDrawGL(screenWidth, screenHeight, mirror);
        }, draw_plane: (gl, projectionMatrix, cameraMatrix, targetMatrix, texture) => {
            drawPlane(gl, projectionMatrix, cameraMatrix, targetMatrix, texture);
        }, draw_grid: (gl, projectionMatrix, cameraMatrix, targetMatrix) => {
            drawGrid(gl, projectionMatrix, cameraMatrix, targetMatrix);
        }, draw_axis: (gl, projectionMatrix, cameraMatrix, targetMatrix) => {
            drawAxis(gl, projectionMatrix, cameraMatrix, targetMatrix);
        }, pipeline_draw_face: (p, projectionMatrix, cameraMatrix, targetMatrix, o) => {
            var _a;
            let obj = getFaceMesh(o);
            if (!obj) {
                zcwarn("attempting to call draw_face on a destroyed zappar_face_mesh_t");
                return new Uint16Array();
            }
            (_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.drawFace(projectionMatrix, cameraMatrix, targetMatrix, obj);
        }, pipeline_draw_face_project: (p, matrix, vertices, uvMatrix, uvs, indices, texture) => {
            var _a;
            (_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.drawFaceProject(matrix, vertices, uvMatrix, uvs, indices, texture);
        }, pipeline_draw_image_target_preview: (p, projectionMatrix, cameraMatrix, targetMatrix, o, indx) => {
            var _a;
            let obj = ImageTracker.get(o);
            if (!obj) {
                zcwarn("image tracker not found");
                return;
            }
            (_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.drawImageTargetPreview(projectionMatrix, cameraMatrix, targetMatrix, indx, obj);
        }, projection_matrix_from_camera_model_and_size: projectionMatrixFromModelAndSize, projection_matrix_from_camera_model_and_size_ext: projectionMatrixFromModelAndSize, pipeline_process_gl: p => { var _a; return (_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.processGL(); }, pipeline_gl_context_set: (p, gl, texturePool) => { var _a; return (_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.glContextSet(gl, texturePool); }, pipeline_gl_context_lost: (p) => { var _a; return (_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.glContextLost(); }, pipeline_camera_frame_upload_gl: p => { var _a; return (_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.uploadGL(); }, pipeline_camera_frame_texture_gl: p => { var _a; return (_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.cameraFrameTexture(); }, pipeline_camera_frame_texture_matrix: (p, sw, sh, mirror) => { var _a; return ((_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.cameraFrameTextureMatrix(sw, sh, mirror)) || mat4.create(); }, pipeline_camera_frame_user_facing: p => { var _a; return ((_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.cameraFrameUserFacing()) || false; }, pipeline_camera_pose_default: () => mat4.create(), pipeline_camera_pose_with_attitude: (p, mirror) => { var _a; return ((_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.cameraPoseWithAttitude(mirror)) || mat4.create(); }, pipeline_camera_pose_with_origin: (p, o) => { let res = mat4.create(); mat4.invert(res, o); return res; }, pipeline_sequence_record_clear: p => { var _a; return (_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.sequenceRecordClear(); }, pipeline_sequence_record_start: (p, expectedFrames) => { var _a; return (_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.sequenceRecordStart(expectedFrames); }, pipeline_sequence_record_stop: p => { var _a; return (_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.sequenceRecordStop(); }, pipeline_sequence_record_device_attitude_matrices_set: (p, v) => { var _a; return (_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.sequenceRecordDeviceAttitudeMatrices(v); }, pipeline_sequence_record_data: p => { var _a; return ((_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.sequenceRecordData()) || new Uint8Array(0); }, pipeline_sequence_record_data_size: p => { var _a; return ((_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.sequenceRecordData().byteLength) || 0; }, pipeline_camera_frame_data_raw: p => { var _a; return ((_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.getCameraFrameDataRaw()) || Promise.reject(); }, pipeline_camera_frame_data_raw_enabled_set: (p, v) => { var _a; return (_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.setCameraFrameDataRawEnabled(v); }, pipeline_camera_frame_data_rgb: p => { var _a; return (_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.getCameraFrameDataRGB(); }, pipeline_camera_frame_data_rgb_enabled_set: (p, v) => { var _a; return (_a = Pipeline.get(p)) === null || _a === void 0 ? void 0 : _a.setCameraFrameDataRGBEnabled(v); }, instant_world_tracker_anchor_pose_camera_relative: (o, mirror) => {
            let res = applyScreenCounterRotation(undefined, c.impl.instant_world_tracker_anchor_pose_raw(o));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            return res;
        }, instant_world_tracker_anchor_pose: (o, cameraPose, mirror) => {
            let res = applyScreenCounterRotation(undefined, c.impl.instant_world_tracker_anchor_pose_raw(o));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            mat4.multiply(res, cameraPose, res);
            return res;
        }, instant_world_tracker_anchor_pose_set_from_camera_offset: (o, x, y, z, orientation) => {
            // TODO - add an _ext function if we need to support mirrored cameras with an extra param
            // if(mirror) {
            //     x *= -1;
            // }
            // TODO - can we access the appropriate pipeline here to call pipeline_camera_frame_user_facing(p)?
            let userFacing = false;
            let rotation = cameraRotationForScreenOrientation(userFacing) * Math.PI / 180.0;
            let rotationMat = mat4.create();
            mat4.fromRotation(rotationMat, -rotation, [0, 0, 1]);
            let rawVec = vec3.create();
            vec3.transformMat4(rawVec, [x, y, z], rotationMat);
            c.impl.instant_world_tracker_anchor_pose_set_from_camera_offset_raw(o, rawVec[0], rawVec[1], rawVec[2], orientation);
        }, custom_anchor_pose_raw: (o) => {
            const entry = customAnchors.get(o);
            if (entry === undefined) {
                zcwarn("attempting to call custom_anchor_pose_raw on a destroyed zappar_custom_anchor_t");
                return mat4.create();
            }
            if (entry.sessionNumber < client.world_tracker_session_number(entry.wt)) {
                // Anchor was set in a previous session, so equivalent to having been reset
                // Status will be reported as STOPPED, report pose the same as world_anchor
                const world_anchor_raw = client.world_tracker_world_anchor_pose_raw(entry.wt).slice();
                return world_anchor_raw;
            }
            // Report underlying pose if version matches expectation
            if (entry.expectedPoseVersion == client.custom_anchor_pose_version(o)) {
                return wtImpl.custom_anchor_pose_raw(o);
            }
            // Use an offset from world anchor until the right pose version is reported
            const world_anchor_raw = client.world_tracker_world_anchor_pose_raw(entry.wt).slice();
            const ret = mat4.create();
            mat4.multiply(ret, world_anchor_raw, entry.poseRelativeToWorldAnchor);
            return ret;
        }, custom_anchor_status: (o) => {
            const entry = customAnchors.get(o);
            if (entry === undefined) {
                zcwarn("attempting to call custom_anchor_status on a destroyed zappar_custom_anchor_t");
                return anchor_status_t.ANCHOR_STATUS_STOPPED;
            }
            if (entry.sessionNumber < client.world_tracker_session_number(entry.wt)) {
                return anchor_status_t.ANCHOR_STATUS_STOPPED;
            }
            // Underlying status if the version and session match 
            if (entry.expectedPoseVersion == client.custom_anchor_pose_version(o)) {
                return wtImpl.custom_anchor_status(o);
            }
            return anchor_status_t.ANCHOR_STATUS_INITIALIZING;
        }, custom_anchor_pose_camera_relative: (o, mirror) => {
            let res = applyScreenCounterRotation(undefined, client.custom_anchor_pose_raw(o));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            return res;
        }, custom_anchor_pose: (o, cameraPose, mirror) => {
            let res = applyScreenCounterRotation(undefined, client.custom_anchor_pose_raw(o));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            mat4.multiply(res, cameraPose, res);
            return res;
        }, custom_anchor_create: (p, wt, id) => {
            const ret = wtImpl.custom_anchor_create(p, wt, id);
            customAnchors.set(ret, { id, wt, sessionNumber: -1, expectedPoseVersion: 0, poseRelativeToWorldAnchor: mat4.create() });
            return ret;
        }, custom_anchor_id: (o) => {
            var _a;
            let id = (_a = customAnchors.get(o)) === null || _a === void 0 ? void 0 : _a.id;
            if (id === undefined) {
                zcwarn("attempting to call custom_anchor_id on a destroyed zappar_custom_anchor_t");
                return "";
            }
            return id;
        }, custom_anchor_pose_set_from_camera_offset: (o, x, y, z, orientation) => {
            const entry = customAnchors.get(o);
            if (entry === undefined) {
                zcwarn("attempting to call custom_anchor_pose_set_from_camera_offset on a destroyed zappar_custom_anchor_t");
                return;
            }
            const pose = mat4.create();
            // camera space -> world anchor transform
            mat4.invert(_temporaryMatrix, client.world_tracker_world_anchor_pose_camera_relative(entry.wt, false));
            _temporaryVec3[0] = x;
            _temporaryVec3[1] = y;
            _temporaryVec3[2] = z;
            switch (orientation) {
                // UNCHANGED and PARENT easiest in camera space
                case transform_orientation_t.PARENT:
                    // Identity rotation in camera space
                    pose[12] = _temporaryVec3[0];
                    pose[13] = _temporaryVec3[1];
                    pose[14] = _temporaryVec3[2];
                    // Convert to world pose
                    mat4.multiply(pose, _temporaryMatrix, pose);
                    break;
                case transform_orientation_t.UNCHANGED:
                    // Take rotation form current camera_relative pose
                    mat4.copy(pose, client.custom_anchor_pose_camera_relative(o, false));
                    pose[12] = _temporaryVec3[0];
                    pose[13] = _temporaryVec3[1];
                    pose[14] = _temporaryVec3[2];
                    // Convert to world pose
                    mat4.multiply(pose, _temporaryMatrix, pose);
                    break;
                // WORLD and Z_TOWARDS_CAMERA easiest in world space
                case transform_orientation_t.WORLD:
                    // Transform the position into world space
                    vec3.transformMat4(_temporaryVec3, _temporaryVec3, _temporaryMatrix);
                    // Rotation bit is already identity
                    pose[12] = _temporaryVec3[0];
                    pose[13] = _temporaryVec3[1];
                    pose[14] = _temporaryVec3[2];
                    break;
                case transform_orientation_t.Z_TOWARDS_CAMERA:
                    // Transform the position into world space
                    vec3.transformMat4(_temporaryVec3, _temporaryVec3, _temporaryMatrix);
                    // Z in pose should be aligned with the xz plane projection of target to camera vector
                    let pose_zx = _temporaryMatrix[12] - _temporaryVec3[0];
                    let pose_zz = _temporaryMatrix[14] - _temporaryVec3[2];
                    let magn2 = pose_zx * pose_zx + pose_zz * pose_zz;
                    if (magn2 > Number.EPSILON) {
                        let scale = 1.0 / (Math.sqrt(magn2));
                        pose_zx *= scale;
                        pose_zz *= scale;
                        pose[8] = pose_zx;
                        pose[10] = pose_zz;
                        // Fill in x axis by rotation matrix properties
                        pose[0] = pose_zz;
                        pose[2] = -pose_zx;
                    }
                    // Fill in the postion
                    pose[12] = _temporaryVec3[0];
                    pose[13] = _temporaryVec3[1];
                    pose[14] = _temporaryVec3[2];
                    break;
            }
            client.custom_anchor_pose_set(o, pose);
        }, custom_anchor_pose_set_from_anchor_offset: (o, anchor_id, x, y, z, orientation) => {
            const entry = customAnchors.get(o);
            if (entry === undefined) {
                zcwarn("attempting to call custom_anchor_pose_set_from_anchor_offset on a destroyed zappar_custom_anchor_t");
                return;
            }
            let anchor_pose;
            if (anchor_id === client.world_tracker_ground_anchor_id(entry.wt)) {
                anchor_pose = client.world_tracker_ground_anchor_pose_raw(entry.wt);
            }
            else if (anchor_id === client.world_tracker_world_anchor_id(entry.wt)) {
                anchor_pose = client.world_tracker_world_anchor_pose_raw(entry.wt);
            }
            else {
                for (let i = 0; i < client.world_tracker_plane_anchor_count(entry.wt); i++) {
                    if (anchor_id === client.world_tracker_plane_anchor_id(entry.wt, i)) {
                        anchor_pose = client.world_tracker_plane_anchor_pose_raw(entry.wt, i);
                        break;
                    }
                }
                if (!anchor_pose) {
                    for (const [anchor, details] of customAnchors.entries()) {
                        if (details.id !== anchor_id)
                            continue;
                        anchor_pose = client.custom_anchor_pose_raw(anchor);
                        break;
                    }
                }
            }
            if (!anchor_pose || anchor_pose.length !== 16) {
                zcwarn("unable for find valid pose for anchor with id", anchor_id);
                return;
            }
            const pose = mat4.create();
            // camera_raw space -> world anchor transform
            mat4.invert(_temporaryMatrix, client.world_tracker_world_anchor_pose_raw(entry.wt));
            // Get position offset relative to camera_raw
            _temporaryVec3[0] = x;
            _temporaryVec3[1] = y;
            _temporaryVec3[2] = z;
            vec3.transformMat4(_temporaryVec3, _temporaryVec3, anchor_pose);
            switch (orientation) {
                // UNCHANGED and PARENT easiest in camera_raw space
                case transform_orientation_t.PARENT:
                    mat4.copy(pose, anchor_pose);
                    pose[12] = _temporaryVec3[0];
                    pose[13] = _temporaryVec3[1];
                    pose[14] = _temporaryVec3[2];
                    // Convert to world pose
                    mat4.multiply(pose, _temporaryMatrix, pose);
                    break;
                case transform_orientation_t.UNCHANGED:
                    mat4.copy(pose, client.custom_anchor_pose_raw(o));
                    pose[12] = _temporaryVec3[0];
                    pose[13] = _temporaryVec3[1];
                    pose[14] = _temporaryVec3[2];
                    // Convert to world pose
                    mat4.multiply(pose, _temporaryMatrix, pose);
                    break;
                // WORLD and Z_TOWARDS_CAMERA easiest in world space
                case transform_orientation_t.WORLD:
                    // Transform the position into world space
                    vec3.transformMat4(_temporaryVec3, _temporaryVec3, _temporaryMatrix);
                    // Rotation bit is already identity
                    pose[12] = _temporaryVec3[0];
                    pose[13] = _temporaryVec3[1];
                    pose[14] = _temporaryVec3[2];
                    break;
                case transform_orientation_t.Z_TOWARDS_CAMERA:
                    // Transform the position into world space
                    vec3.transformMat4(_temporaryVec3, _temporaryVec3, _temporaryMatrix);
                    // Z in pose should be aligned with the xz plane projection of target to camera vector
                    let pose_zx = _temporaryMatrix[12] - _temporaryVec3[0];
                    let pose_zz = _temporaryMatrix[14] - _temporaryVec3[2];
                    let magn2 = pose_zx * pose_zx + pose_zz * pose_zz;
                    if (magn2 > Number.EPSILON) {
                        let scale = 1.0 / (Math.sqrt(magn2));
                        pose_zx *= scale;
                        pose_zz *= scale;
                        pose[8] = pose_zx;
                        pose[10] = pose_zz;
                        // Fill in x axis by rotation matrix properties
                        pose[0] = pose_zz;
                        pose[2] = -pose_zx;
                    }
                    // Fill in the postion
                    pose[12] = _temporaryVec3[0];
                    pose[13] = _temporaryVec3[1];
                    pose[14] = _temporaryVec3[2];
                    break;
            }
            client.custom_anchor_pose_set_with_parent(o, pose, anchor_id);
        }, custom_anchor_pose_set: (o, pose) => {
            const entry = customAnchors.get(o);
            if (entry === undefined) {
                zcwarn("attempting to call custom_anchor_pose_set on a destroyed zappar_custom_anchor_t");
                return;
            }
            entry.sessionNumber = client.world_tracker_session_number(entry.wt);
            entry.expectedPoseVersion++;
            mat4.copy(entry.poseRelativeToWorldAnchor, pose);
            wtImpl.custom_anchor_pose_set(o, pose);
        }, custom_anchor_pose_set_with_parent: (o, pose, anchor_id) => {
            const entry = customAnchors.get(o);
            if (entry === undefined) {
                zcwarn("attempting to call custom_anchor_pose_set_with_parent on a destroyed zappar_custom_anchor_t");
                return;
            }
            entry.sessionNumber = client.world_tracker_session_number(entry.wt);
            entry.expectedPoseVersion++;
            mat4.copy(entry.poseRelativeToWorldAnchor, pose);
            wtImpl.custom_anchor_pose_set_with_parent(o, pose, anchor_id);
        }, custom_anchor_destroy: (o) => {
            customAnchors.delete(o);
            wtImpl.custom_anchor_destroy(o);
        }, image_tracker_create: pipeline => ImageTracker.create(pipeline, c.impl), image_tracker_destroy: t => { var _a; return (_a = ImageTracker.get(t)) === null || _a === void 0 ? void 0 : _a.destroy(); }, image_tracker_target_type: (t, i) => {
            let obj = ImageTracker.get(t);
            if (!obj) {
                zcwarn("attempting to call image_tracker_target_type on a destroyed zappar_image_tracker_t");
                return image_target_type_t.IMAGE_TRACKER_TYPE_PLANAR;
            }
            return obj.getTargetInfo(i).type;
        }, image_tracker_target_count: t => {
            let obj = ImageTracker.get(t);
            if (!obj) {
                zcwarn("attempting to call image_tracker_target_count on a destroyed zappar_image_tracker_t");
                return 0;
            }
            return obj.targetCount();
        }, image_tracker_target_load_from_memory: (t, data) => {
            let obj = ImageTracker.get(t);
            if (!obj) {
                zcwarn("attempting to call image_tracker_target_load_from_memory on a destroyed zappar_image_tracker_t");
                return 0;
            }
            obj.loadFromMemory(data);
        }, image_tracker_target_preview_compressed: (t, i) => {
            var _a;
            let obj = ImageTracker.get(t);
            if (!obj) {
                zcwarn("attempting to call image_tracker_target_preview_compressed on a destroyed zappar_image_tracker_t");
                return new Uint8Array(0);
            }
            return ((_a = obj.getTargetInfo(i).preview) === null || _a === void 0 ? void 0 : _a.compressed) || new Uint8Array(0);
        }, image_tracker_target_preview_compressed_mimetype: (t, i) => {
            var _a;
            let obj = ImageTracker.get(t);
            if (!obj) {
                zcwarn("attempting to call image_tracker_target_preview_compressed_mimetype on a destroyed zappar_image_tracker_t");
                return "";
            }
            return ((_a = obj.getTargetInfo(i).preview) === null || _a === void 0 ? void 0 : _a.mimeType) || "";
        }, image_tracker_target_preview_compressed_size: (t, i) => {
            var _a, _b;
            let obj = ImageTracker.get(t);
            if (!obj) {
                zcwarn("attempting to call image_tracker_target_preview_compressed_size on a destroyed zappar_image_tracker_t");
                return 0;
            }
            return ((_b = (_a = obj.getTargetInfo(i).preview) === null || _a === void 0 ? void 0 : _a.compressed) === null || _b === void 0 ? void 0 : _b.byteLength) || 0;
        }, image_tracker_target_physical_scale_factor: (t, i) => {
            let obj = ImageTracker.get(t);
            if (!obj) {
                zcwarn("attempting to call image_tracker_target_physical_scale_factor on a destroyed zappar_image_tracker_t");
                return 0;
            }
            return obj.getTargetInfo(i).physicalScaleFactor;
        }, image_tracker_target_radius_top: (t, i) => {
            let obj = ImageTracker.get(t);
            if (!obj) {
                zcwarn("attempting to call image_tracker_target_radius_top on a destroyed zappar_image_tracker_t");
                return 0;
            }
            return obj.getTargetInfo(i).topRadius;
        }, image_tracker_target_radius_bottom: (t, i) => {
            let obj = ImageTracker.get(t);
            if (!obj) {
                zcwarn("attempting to call image_tracker_target_radius_bottom on a destroyed zappar_image_tracker_t");
                return 0;
            }
            return obj.getTargetInfo(i).bottomRadius;
        }, image_tracker_target_side_length: (t, i) => {
            let obj = ImageTracker.get(t);
            if (!obj) {
                zcwarn("attempting to call image_tracker_target_side_length on a destroyed zappar_image_tracker_t");
                return 0;
            }
            return obj.getTargetInfo(i).sideLength;
        }, image_tracker_target_image: (t, i) => {
            let obj = ImageTracker.get(t);
            if (!obj) {
                zcwarn("attempting to call image_tracker_target_image on a destroyed zappar_image_tracker_t");
                return new Image();
            }
            return obj.getDecodedPreview(i);
        }, image_tracker_anchor_pose_camera_relative: (o, indx, mirror) => {
            let res = applyScreenCounterRotation(undefined, c.impl.image_tracker_anchor_pose_raw(o, indx));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            return res;
        }, image_tracker_anchor_pose: (o, indx, cameraPose, mirror) => {
            let res = applyScreenCounterRotation(undefined, c.impl.image_tracker_anchor_pose_raw(o, indx));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            mat4.multiply(res, cameraPose, res);
            return res;
        }, image_tracker_target_preview_mesh_indices: (o, indx) => {
            let obj = ImageTracker.get(o);
            if (!obj) {
                zcwarn("attempting to call image_tracker_target_preview_mesh_indices on a destroyed zappar_image_tracker_t");
                return new Uint16Array();
            }
            return obj.getPreviewMesh(indx).indices;
        }, image_tracker_target_preview_mesh_vertices: (o, indx) => {
            let obj = ImageTracker.get(o);
            if (!obj) {
                zcwarn("attempting to call image_tracker_target_preview_mesh_vertices on a destroyed zappar_image_tracker_t");
                return new Float32Array();
            }
            return obj.getPreviewMesh(indx).vertices;
        }, image_tracker_target_preview_mesh_uvs: (o, indx) => {
            let obj = ImageTracker.get(o);
            if (!obj) {
                zcwarn("attempting to call image_tracker_target_preview_mesh_uvs on a destroyed zappar_image_tracker_t");
                return new Float32Array();
            }
            return obj.getPreviewMesh(indx).uvs;
        }, image_tracker_target_preview_mesh_normals: (o, indx) => {
            let obj = ImageTracker.get(o);
            if (!obj) {
                zcwarn("attempting to call image_tracker_target_preview_mesh_normals on a destroyed zappar_image_tracker_t");
                return new Float32Array();
            }
            return obj.getPreviewMesh(indx).normals;
        }, image_tracker_target_preview_mesh_indices_size: (o, indx) => {
            let obj = ImageTracker.get(o);
            if (!obj) {
                zcwarn("attempting to call image_tracker_target_preview_mesh_indices_size on a destroyed zappar_image_tracker_t");
                return 0;
            }
            return obj.getPreviewMesh(indx).indices.length;
        }, image_tracker_target_preview_mesh_vertices_size: (o, indx) => {
            let obj = ImageTracker.get(o);
            if (!obj) {
                zcwarn("attempting to call image_tracker_target_preview_mesh_vertices_size on a destroyed zappar_image_tracker_t");
                return 0;
            }
            return obj.getPreviewMesh(indx).vertices.length;
        }, image_tracker_target_preview_mesh_uvs_size: (o, indx) => {
            let obj = ImageTracker.get(o);
            if (!obj) {
                zcwarn("attempting to call image_tracker_target_preview_mesh_uvs_size on a destroyed zappar_image_tracker_t");
                return 0;
            }
            return obj.getPreviewMesh(indx).uvs.length;
        }, image_tracker_target_preview_mesh_normals_size: (o, indx) => {
            let obj = ImageTracker.get(o);
            if (!obj) {
                zcwarn("attempting to call image_tracker_target_preview_mesh_normals_size on a destroyed zappar_image_tracker_t");
                return 0;
            }
            return obj.getPreviewMesh(indx).normals.length;
        }, zapcode_tracker_anchor_pose_camera_relative: (o, indx, mirror) => {
            let res = applyScreenCounterRotation(undefined, c.impl.zapcode_tracker_anchor_pose_raw(o, indx));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            return res;
        }, zapcode_tracker_anchor_pose: (o, indx, cameraPose, mirror) => {
            let res = applyScreenCounterRotation(undefined, c.impl.zapcode_tracker_anchor_pose_raw(o, indx));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            mat4.multiply(res, cameraPose, res);
            return res;
        }, face_tracker_anchor_pose_camera_relative: (o, indx, mirror) => {
            let res = applyScreenCounterRotation(undefined, c.impl.face_tracker_anchor_pose_raw(o, indx));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            return res;
        }, face_tracker_anchor_pose: (o, indx, cameraPose, mirror) => {
            let res = applyScreenCounterRotation(undefined, c.impl.face_tracker_anchor_pose_raw(o, indx));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            mat4.multiply(res, cameraPose, res);
            return res;
        }, face_tracker_model_load_default: (o) => __awaiter(this, void 0, void 0, function* () {
            yield loadDefaultFaceModel(o);
        }), face_mesh_create: () => {
            return createFaceMesh();
        }, face_mesh_destroy: (m) => {
            destroyFaceMesh(m);
        }, face_mesh_indices: (m) => {
            let obj = getFaceMesh(m);
            if (!obj) {
                zcwarn("attempting to call face_mesh_indices on a destroyed zappar_face_mesh_t");
                return new Uint16Array();
            }
            return obj.getIndices();
        }, face_mesh_indices_size: (m) => {
            let obj = getFaceMesh(m);
            if (!obj) {
                zcwarn("attempting to call face_mesh_indices_size on a destroyed zappar_face_mesh_t");
                return 0;
            }
            return obj.getIndices().length;
        }, face_mesh_uvs: (m) => {
            let obj = getFaceMesh(m);
            if (!obj) {
                zcwarn("attempting to call face_mesh_uvs on a destroyed zappar_face_mesh_t");
                return new Float32Array();
            }
            return obj.getUVs();
        }, face_mesh_uvs_size: (m) => {
            let obj = getFaceMesh(m);
            if (!obj) {
                zcwarn("attempting to call face_mesh_uvs_size on a destroyed zappar_face_mesh_t");
                return 0;
            }
            return obj.getUVs().length;
        }, face_mesh_vertices: (m) => {
            let obj = getFaceMesh(m);
            if (!obj) {
                zcwarn("attempting to call face_mesh_vertices on a destroyed zappar_face_mesh_t");
                return new Float32Array();
            }
            return obj.getVertices();
        }, face_mesh_vertices_size: (m) => {
            let obj = getFaceMesh(m);
            if (!obj) {
                zcwarn("attempting to call face_mesh_vertices_size on a destroyed zappar_face_mesh_t");
                return 0;
            }
            return obj.getVertices().length;
        }, face_mesh_normals: (m) => {
            let obj = getFaceMesh(m);
            if (!obj) {
                zcwarn("attempting to call face_mesh_normals on a destroyed zappar_face_mesh_t");
                return new Float32Array();
            }
            return obj.getNormals();
        }, face_mesh_normals_size: (m) => {
            let obj = getFaceMesh(m);
            if (!obj) {
                zcwarn("attempting to call face_mesh_normals_size on a destroyed zappar_face_mesh_t");
                return 0;
            }
            return obj.getNormals().length;
        }, face_mesh_load_from_memory: (m, ab, fillMouth, fillEyeL, fillEyeR, fillNeck) => {
            let obj = getFaceMesh(m);
            if (!obj) {
                zcwarn("attempting to call face_mesh_load_from_memory on a destroyed zappar_face_mesh_t");
                return;
            }
            obj.loadFromMemory(ab, fillMouth, fillEyeL, fillEyeR, fillNeck);
        }, face_mesh_update: (m, identity, expression, mirrored) => {
            let obj = getFaceMesh(m);
            if (!obj) {
                zcwarn("attempting to call face_mesh_update on a destroyed zappar_face_mesh_t");
                return;
            }
            obj.update(identity, expression, mirrored);
        }, face_mesh_load_default: (m) => __awaiter(this, void 0, void 0, function* () {
            let obj = getFaceMesh(m);
            if (!obj) {
                zcwarn("attempting to call face_mesh_load_default on a destroyed zappar_face_mesh_t");
                return;
            }
            let url = new URL("./face_mesh_face_model.zbin", import.meta.url);
            let req = yield fetch(url.toString());
            obj.loadFromMemory(yield req.arrayBuffer(), false, false, false, false);
        }), face_mesh_load_default_face: (m, fillMouth, fillEyeL, fillEyeR) => __awaiter(this, void 0, void 0, function* () {
            let obj = getFaceMesh(m);
            if (!obj) {
                zcwarn("attempting to call face_mesh_load_default_face on a destroyed zappar_face_mesh_t");
                return;
            }
            let url = new URL("./face_mesh_face_model.zbin", import.meta.url);
            let req = yield fetch(url.toString());
            obj.loadFromMemory(yield req.arrayBuffer(), fillMouth, fillEyeL, fillEyeR, false);
        }), face_mesh_load_default_full_head_simplified: (m, fillMouth, fillEyeL, fillEyeR, fillNeck) => __awaiter(this, void 0, void 0, function* () {
            let obj = getFaceMesh(m);
            if (!obj) {
                zcwarn("attempting to call face_mesh_load_default_full_head_simplified on a destroyed zappar_face_mesh_t");
                return;
            }
            let url = new URL("./face_mesh_full_head_simplified_model.zbin", import.meta.url);
            let req = yield fetch(url.toString());
            obj.loadFromMemory(yield req.arrayBuffer(), fillMouth, fillEyeL, fillEyeR, fillNeck);
        }), face_mesh_loaded_version: (m) => {
            let obj = getFaceMesh(m);
            if (!obj) {
                zcwarn("attempting to call face_mesh_load_default on a destroyed zappar_face_mesh_t");
                return -1;
            }
            return obj.getModelVersion();
        }, face_landmark_create: (n) => {
            return createFaceLandmark(n);
        }, face_landmark_destroy: (m) => {
            destroyFaceLandmark(m);
        }, face_landmark_update: (m, identity, expression, mirrored) => {
            let obj = getFaceLandmark(m);
            if (!obj) {
                zcwarn("attempting to call face_landmark_update on a destroyed zappar_face_landmark_t");
                return;
            }
            obj.update(identity, expression, mirrored);
        }, face_landmark_anchor_pose: (m) => {
            let obj = getFaceLandmark(m);
            if (!obj) {
                zcwarn("attempting to call face_landmark_anchor_pose on a destroyed zappar_face_landmark_t");
                return mat4.create();
            }
            return obj.anchor_pose;
        }, world_tracker_create: (pipeline) => {
            const ret = wtImpl.world_tracker_create(pipeline);
            pipelineByWorldTracker.set(ret, pipeline);
            return ret;
        }, world_tracker_points_data_matrix: (wt, screenWidth, screenHeight, mirror) => {
            const pipeline = pipelineByWorldTracker.get(wt);
            if (pipeline === undefined || !client)
                return mat4.create();
            return getPointsDataMatrix(client.pipeline_camera_data_width(pipeline), client.pipeline_camera_data_height(pipeline), screenWidth, screenHeight, mirror);
        }, world_tracker_plane_anchor_pose_camera_relative: (o, indx, mirror) => {
            let res = applyScreenCounterRotation(undefined, client.world_tracker_plane_anchor_pose_raw(o, indx));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            return res;
        }, world_tracker_plane_anchor_pose: (o, indx, cameraPose, mirror) => {
            let res = applyScreenCounterRotation(undefined, client.world_tracker_plane_anchor_pose_raw(o, indx));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            mat4.multiply(res, cameraPose, res);
            return res;
        }, world_tracker_world_anchor_pose: (o, cameraPose, mirror) => {
            let res = applyScreenCounterRotation(undefined, client.world_tracker_world_anchor_pose_raw(o));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            mat4.multiply(res, cameraPose, res);
            return res;
        }, world_tracker_world_anchor_pose_camera_relative: (o, mirror) => {
            let res = applyScreenCounterRotation(undefined, client.world_tracker_world_anchor_pose_raw(o));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            return res;
        }, world_tracker_ground_anchor_pose: (o, cameraPose, mirror) => {
            let res = applyScreenCounterRotation(undefined, client.world_tracker_ground_anchor_pose_raw(o));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            mat4.multiply(res, cameraPose, res);
            return res;
        }, world_tracker_ground_anchor_pose_camera_relative: (o, mirror) => {
            let res = applyScreenCounterRotation(undefined, client.world_tracker_ground_anchor_pose_raw(o));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            return res;
        }, world_tracker_vertical_plane_detection_supported: (o) => {
            if (bridgedWtApi)
                return true;
            return false;
        }, world_tracker_mesh_anchor_pose_camera_relative: (o, indx, mirror) => {
            let res = applyScreenCounterRotation(undefined, client.world_tracker_mesh_anchor_pose_raw(o, indx));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            return res;
        }, world_tracker_mesh_anchor_pose: (o, indx, cameraPose, mirror) => {
            let res = applyScreenCounterRotation(undefined, client.world_tracker_mesh_anchor_pose_raw(o, indx));
            if (mirror) {
                let scale = mat4.create();
                mat4.fromScaling(scale, [-1, 1, 1]);
                mat4.multiply(res, scale, res);
                mat4.multiply(res, res, scale);
            }
            mat4.multiply(res, cameraPose, res);
            return res;
        }, html_element_source_create: (pipeline, elm) => HTMLElementSource.createVideoElementSource(pipeline, elm), html_element_source_start: o => { var _a; return (_a = HTMLElementSource.getVideoElementSource(o)) === null || _a === void 0 ? void 0 : _a.start(); }, html_element_source_pause: o => { var _a; return (_a = HTMLElementSource.getVideoElementSource(o)) === null || _a === void 0 ? void 0 : _a.pause(); }, html_element_source_destroy: o => { var _a; return (_a = HTMLElementSource.getVideoElementSource(o)) === null || _a === void 0 ? void 0 : _a.destroy(); }, sequence_source_create: p => SequenceSource.create(p), sequence_source_load_from_memory: (o, data) => { var _a; return (_a = SequenceSource.get(o)) === null || _a === void 0 ? void 0 : _a.loadFromMemory(data); }, sequence_source_pause: o => { var _a; return (_a = SequenceSource.get(o)) === null || _a === void 0 ? void 0 : _a.pause(); }, sequence_source_start: o => { var _a; return (_a = SequenceSource.get(o)) === null || _a === void 0 ? void 0 : _a.start(); }, sequence_source_max_playback_fps_set: (o, fps) => { var _a; return (_a = SequenceSource.get(o)) === null || _a === void 0 ? void 0 : _a.maxPlaybackFpsSet(fps); }, sequence_source_time_set: (o, t) => { var _a; return (_a = SequenceSource.get(o)) === null || _a === void 0 ? void 0 : _a.setTime(t); }, sequence_source_destroy: o => { var _a; return (_a = SequenceSource.get(o)) === null || _a === void 0 ? void 0 : _a.destroy(); }, permission_granted_all: permissionGrantedAll, permission_granted_camera: permissionGrantedCamera, permission_granted_motion: permissionGrantedMotion, permission_denied_any: permissionDeniedAny, permission_denied_camera: permissionDeniedCamera, permission_denied_motion: permissionDeniedMotion, permission_request_motion: permissionRequestMotion, permission_request_camera: permissionRequestCamera, permission_request_all: permissionRequestAll, permission_request_ui: permissionRequestUI, permission_request_ui_promise: permissionRequestUI, permission_denied_ui: permissionDeniedUI, browser_incompatible: compatibility.incompatible, browser_incompatible_ui: compatibility.incompatible_ui, in_app_clip: () => BridgedCameraSource.IsSupported(), log_level_set: l => {
            setLogLevel(l);
            c.impl.log_level_set(l);
        }, cookies_permitted: p => {
            if (p) {
                if (!hasPersistedUID) {
                    persistUID(uid);
                    hasPersistedUID = true;
                }
            }
            else {
                deleteUID();
            }
        } });
    return client;
}
function loadDefaultFaceModel(o) {
    return __awaiter(this, void 0, void 0, function* () {
        let url = new URL("./face_tracking_model.zbin", import.meta.url);
        let data = yield fetch(url.toString());
        let ab = yield data.arrayBuffer();
        client === null || client === void 0 ? void 0 : client.face_tracker_model_load_from_memory(o, ab);
    });
}
function getUID() {
    let uid = window.localStorage.getItem('z_uar_lid');
    if (uid === null) {
        const destination = new Uint8Array(8);
        window.crypto.getRandomValues(destination);
        uid = '';
        for (let i = 0; i < destination.byteLength; i++) {
            const part = destination[i].toString(16);
            if (part.length === 1)
                uid += '0' + part;
            else if (part.length === 2)
                uid += part;
        }
    }
    return uid;
}
function persistUID(u) {
    window.localStorage.setItem('z_uar_lid', u);
}
function deleteUID() {
    window.localStorage.removeItem('z_uar_lid');
}
